package com.beem.project.beem.ui;

import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.AdapterView.OnItemClickListener;

import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;

/**
 * This activity class provides the view for user infos after long click on a correspondant.
 * @author marseille
 */
public class UserInfo extends Activity {

    private Contact mContact;
    private static final List<String> mInfo = new ArrayList<String>();

    static {
	mInfo.add("alias");
    }

    /**
     * Constructor.
     */
    public UserInfo() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.userinfo);
	mContact = new Contact(getIntent().getData());
	setTitle(mContact.getName());
	ListView listview = (ListView) findViewById(R.id.userinfo);
	listview.setAdapter(new BeemUserInfo(this));
	listview.setOnItemClickListener(new BeemUserInfoClick());
    }
    
    /**
     * Event simple click on item of the user info.
     */
    public class BeemUserInfoClick implements OnItemClickListener {
	@Override
	public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
	    Log.i("OOO", mInfo.get(arg2));
	}
    }

    /**
     * Adapter user info list.
     */
    public class BeemUserInfo extends BaseAdapter {
	private LayoutInflater mInflater;

	/**
	 * Constructor.
	 * @param c context activity.
	 */
	public BeemUserInfo(final Context c) {
	    mInflater = LayoutInflater.from(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getCount() {
	    return mInfo.size();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getItem(int position) {
	    return position;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public long getItemId(int position) {
	    return position;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
	    View v = convertView;
	    if (convertView == null) {
		if (position == 0)
		    v = mInflater.inflate(R.layout.userinfo_alias, null);
	    }
	    return v;
	}
    }

}
