/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.util.regex.Pattern;
import org.umlgraph.doclet.ClassMatcher;

public class InterfaceMatcher
implements ClassMatcher {
    protected RootDoc root;
    protected Pattern pattern;

    public InterfaceMatcher(RootDoc root, Pattern pattern) {
        this.root = root;
        this.pattern = pattern;
    }

    @Override
    public boolean matches(ClassDoc cd) {
        if (cd.isInterface() && this.pattern.matcher(cd.toString()).matches()) {
            return true;
        }
        for (ClassDoc iface : cd.interfaces()) {
            if (!this.matches(iface)) continue;
            return true;
        }
        if (cd.superclass() != null) {
            return this.matches(cd.superclass());
        }
        return false;
    }

    @Override
    public boolean matches(String name) {
        ClassDoc cd = this.root.classNamed(name);
        if (cd == null) {
            return false;
        }
        return this.matches(cd);
    }
}

