/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.net.InetSocketAddress;
import org.jlibrtp.jlibrtp.core.PktBuffer;
import org.jlibrtp.jlibrtp.core.RtpPkt;
import org.jlibrtp.jlibrtp.core.StaticProcs;

public class Participant {
    protected boolean unexpected = false;
    protected InetSocketAddress rtpAddress = null;
    protected InetSocketAddress rtcpAddress = null;
    protected InetSocketAddress rtpReceivedFromAddress = null;
    protected InetSocketAddress rtcpReceivedFromAddress = null;
    protected long ssrc = -1L;
    protected String cname = null;
    protected String name = null;
    protected String email = null;
    protected String phone = null;
    protected String loc = null;
    protected String tool = null;
    protected String note = null;
    protected String priv = null;
    protected int firstSeqNumber = -1;
    protected int lastSeqNumber = 0;
    protected long seqRollOverCount = 0L;
    protected long receivedPkts = 0L;
    protected long receivedOctets = 0L;
    protected int receivedSinceLastSR = 0;
    protected int lastSRRseqNumber = 0;
    protected double interArrivalJitter = -1.0;
    protected long lastRtpTimestamp = 0L;
    protected long timeStampLSR = 0L;
    protected long timeReceivedLSR = 0L;
    protected double ntpGradient = -1.0;
    protected long ntpOffset = -1L;
    protected long lastNtpTs1 = 0L;
    protected long lastNtpTs2 = 0L;
    protected long lastSRRtpTs = 0L;
    protected long timestampBYE = -1L;
    protected PktBuffer pktBuffer = null;
    protected long lastRtpPkt = -1L;
    protected long lastRtcpPkt = -1L;
    protected long addedByApp = -1L;
    protected long lastRtcpRRPkt = -1L;
    protected long secondLastRtcpRRPkt = -1L;

    public Participant(String networkAddress, int rtpPort, int rtcpPort) {
        if (rtpPort > 0) {
            try {
                this.rtpAddress = new InetSocketAddress(networkAddress, rtpPort);
            }
            catch (Exception e) {
                System.out.println("Couldn't resolve " + networkAddress);
            }
        }
        if (rtcpPort > 0) {
            try {
                this.rtcpAddress = new InetSocketAddress(networkAddress, rtcpPort);
            }
            catch (Exception e) {
                System.out.println("Couldn't resolve " + networkAddress);
            }
        }
    }

    protected Participant(InetSocketAddress rtpAdr, InetSocketAddress rtcpAdr, long SSRC) {
        this.rtpReceivedFromAddress = rtpAdr;
        this.rtcpReceivedFromAddress = rtcpAdr;
        this.ssrc = SSRC;
        this.unexpected = true;
    }

    protected Participant() {
        System.out.println("Don't use the Participan(void) Constructor!");
    }

    InetSocketAddress getRtpSocketAddress() {
        return this.rtpAddress;
    }

    InetSocketAddress getRtcpSocketAddress() {
        return this.rtcpAddress;
    }

    InetSocketAddress getRtpReceivedFromAddress() {
        return this.rtpAddress;
    }

    InetSocketAddress getRtcpReceivedFromAddress() {
        return this.rtcpAddress;
    }

    public String getCNAME() {
        return this.cname;
    }

    public String getNAME() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getLocation() {
        return this.loc;
    }

    public String getNote() {
        return this.note;
    }

    public String getPriv() {
        return this.priv;
    }

    public String getTool() {
        return this.tool;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    protected void updateRRStats(int packetLength, RtpPkt pkt) {
        int curSeqNum = pkt.getSeqNumber();
        if (this.firstSeqNumber < 0) {
            this.firstSeqNumber = curSeqNum;
        }
        this.receivedOctets += (long)packetLength;
        ++this.receivedSinceLastSR;
        ++this.receivedPkts;
        long curTime = System.currentTimeMillis();
        if (this.lastSeqNumber < curSeqNum) {
            this.lastSeqNumber = curSeqNum;
        } else if (this.lastSeqNumber - this.lastSeqNumber < -100) {
            this.lastSeqNumber = curSeqNum;
            ++this.seqRollOverCount;
        }
        if (this.lastRtpPkt > 0L) {
            long D = pkt.getTimeStamp() - curTime - (this.lastRtpTimestamp - this.lastRtpPkt);
            if (D < 0L) {
                D *= -1L;
            }
            this.interArrivalJitter += ((double)D - this.interArrivalJitter) / 16.0;
        }
        this.lastRtpPkt = curTime;
        this.lastRtpTimestamp = pkt.getTimeStamp();
    }

    protected long getExtHighSeqRecv() {
        return 65536L * this.seqRollOverCount + (long)this.lastSeqNumber;
    }

    protected int getFractionLost() {
        int expected = this.lastSeqNumber - this.lastSRRseqNumber;
        if (expected < 0) {
            expected += 65536;
        }
        int fraction = 256 * (expected - this.receivedSinceLastSR);
        fraction = expected > 0 ? (fraction /= expected) : 0;
        this.receivedSinceLastSR = 0;
        this.lastSRRseqNumber = this.lastSeqNumber;
        return fraction;
    }

    protected long getLostPktCount() {
        long lost = this.getExtHighSeqRecv() - (long)this.firstSeqNumber - this.receivedPkts;
        if (lost < 0L) {
            lost = 0L;
        }
        return lost;
    }

    protected double getInterArrivalJitter() {
        return this.interArrivalJitter;
    }

    protected void setTimeStampLSR(long ntp1, long ntp2) {
        byte[] high = StaticProcs.uIntLongToByteWord(ntp1);
        byte[] low = StaticProcs.uIntLongToByteWord(ntp2);
        low[3] = low[1];
        low[2] = low[0];
        low[1] = high[3];
        low[0] = high[2];
        this.timeStampLSR = StaticProcs.bytesToUIntLong(low, 0);
    }

    protected long delaySinceLastSR() {
        if (this.timeReceivedLSR < 1L) {
            return 0L;
        }
        long delay = System.currentTimeMillis() - this.timeReceivedLSR;
        return (long)((double)delay * 65.536);
    }

    public void debugPrint() {
        System.out.print(" Participant.debugPrint() SSRC:" + this.ssrc + " CNAME:" + this.cname);
        if (this.rtpAddress != null) {
            System.out.print(" RTP:" + this.rtpAddress.toString());
        }
        if (this.rtcpAddress != null) {
            System.out.print(" RTCP:" + this.rtcpAddress.toString());
        }
        System.out.println("");
        System.out.println("                          Packets received:" + this.receivedPkts);
    }
}

