package com.beem.project.beem.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;

/**
 * This activity class provides the view for user infos after long click on a correspondant.
 * @author marseille
 */
public class UserInfo extends Activity {

    private Contact mContact;

    /**
     * Constructor.
     */
    public UserInfo() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.userinfo);
	mContact = new Contact(getIntent().getData());
	setTitle(mContact.getName());
	ListView listview = (ListView) findViewById(R.id.userinfo);
	listview.setAdapter(new BeemUserInfo(this));
    }

    /**
     * Adapter banner list.
     */
    public class BeemUserInfo extends BaseAdapter {
	private LayoutInflater mInflater;

	/**
	 * Constructor.
	 * @param c context activity.
	 */
	public BeemUserInfo(final Context c) {
	    mInflater = LayoutInflater.from(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getCount() {
	    return 1;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getItem(int position) {
	    return position;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public long getItemId(int position) {
	    return position;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
	    View v = convertView;
	    if (convertView == null) {
		v = mInflater.inflate(R.id.userinfo_alias, null);
	    }
	    return v;
	}

    }

}
