package com.zadov.beem;

import net.java.otr4j.OtrEngineHostImpl;
import net.java.otr4j.OtrEngineImpl;
import net.java.otr4j.OtrPolicy;
import net.java.otr4j.OtrPolicyImpl;
import net.java.otr4j.session.SessionID;
import android.util.Log;

import com.beem.project.beem.service.ChatAdapter;

public class BeemOtrManager {

	private static final String TAG = "BeemOtrManager";
	protected ChatAdapter mChat;
	protected OtrEngineHostImpl myHost;
	private OtrEngineImpl usAlice;
	private SessionID aliceSessionID;

	public BeemOtrManager(ChatAdapter chat, String jidres, String jid){
		mChat = chat;
		myHost = new OtrEngineHostImpl(chat, 
				new OtrPolicyImpl(OtrPolicy.ALLOW_V2
						| OtrPolicy.ERROR_START_AKE));
		aliceSessionID = new SessionID(jidres,jid, "XMMP");
		usAlice = new OtrEngineImpl(myHost);
	}

	public void startSession() {
		usAlice.startSession(aliceSessionID);
	}
	
	public void endSession() {
		usAlice.endSession(aliceSessionID);
	}

	public String status() {
		return usAlice.getSessionStatus(aliceSessionID).toString();
	}
	
	public String recieveMessage(String msg) {
		Log.d(TAG, "in: "+msg);
		String plain = null;
		//mChat.otrStatusDisplay.setText("otr status: "+usAlice.getSessionStatus(aliceSessionID).toString());
		if(usAlice != null){
			plain = usAlice.transformReceiving(aliceSessionID, msg);
		}
		Log.d(TAG,"in: "+plain);
		return plain;
	}
	
	public String sendMessage(String msg) {
		Log.d(TAG, "out: "+msg);
		//mChat.otrStatusDisplay.setText("otr status: "+usAlice.getSessionStatus(aliceSessionID).toString());
		if(usAlice != null){
			msg = usAlice.transformSending(aliceSessionID, msg);
		}
		Log.d(TAG, "out: "+msg);
		return msg;
	}

}
