/*
 * Decompiled with CFR 0.152.
 */
package org.jlibrtp.jlibrtp.core;

import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Iterator;
import org.jlibrtp.jlibrtp.core.CompRtcpPkt;
import org.jlibrtp.jlibrtp.core.Participant;
import org.jlibrtp.jlibrtp.core.RTCPSession;
import org.jlibrtp.jlibrtp.core.RTPSession;
import org.jlibrtp.jlibrtp.core.RtcpPkt;
import org.jlibrtp.jlibrtp.core.RtcpPktAPP;
import org.jlibrtp.jlibrtp.core.RtcpPktBYE;
import org.jlibrtp.jlibrtp.core.RtcpPktRR;
import org.jlibrtp.jlibrtp.core.RtcpPktSDES;
import org.jlibrtp.jlibrtp.core.RtcpPktSR;

public class RTCPSenderThread
extends Thread {
    private RTPSession rtpSession = null;
    private RTCPSession rtcpSession = null;
    private boolean byesSent = false;

    protected RTCPSenderThread(RTCPSession rtcpSession, RTPSession rtpSession) {
        this.rtpSession = rtpSession;
        this.rtcpSession = rtcpSession;
    }

    protected void sendByes() {
        CompRtcpPkt compPkt = new CompRtcpPkt();
        RtcpPktSR srPkt = new RtcpPktSR(this.rtpSession.ssrc, this.rtpSession.sentPktCount, this.rtpSession.sentOctetCount, null);
        compPkt.addPacket(srPkt);
        long[] ssrcArray = new long[]{this.rtpSession.ssrc};
        byte[] reasonBytes = this.rtpSession.conflict ? "SSRC collision".getBytes() : "jlibrtp says bye bye!".getBytes();
        RtcpPktBYE byePkt = new RtcpPktBYE(ssrcArray, reasonBytes);
        compPkt.addPacket(byePkt);
        if (this.rtpSession.mcSession) {
            this.mcSendCompRtcpPkt(compPkt);
        } else {
            Iterator iter = this.rtpSession.partDb.getUnicastReceivers();
            while (iter.hasNext()) {
                Participant part = (Participant)iter.next();
                if (part.rtcpAddress == null) continue;
                this.sendCompRtcpPkt(compPkt, part.rtcpAddress);
            }
        }
    }

    protected int mcSendCompRtcpPkt(CompRtcpPkt pkt) {
        DatagramPacket packet;
        byte[] pktBytes = pkt.encode();
        try {
            packet = new DatagramPacket(pktBytes, pktBytes.length, this.rtpSession.mcGroup, this.rtcpSession.rtcpMCSock.getPort());
        }
        catch (Exception e) {
            System.out.println("RCTPSenderThread.MCSendCompRtcpPkt() packet creation failed.");
            e.printStackTrace();
            return -1;
        }
        try {
            this.rtcpSession.rtcpMCSock.send(packet);
            if (this.rtpSession.debugAppIntf != null) {
                this.rtpSession.debugAppIntf.packetSent(3, (InetSocketAddress)packet.getSocketAddress(), new String("Sent multicast RTCP packet of size " + packet.getLength() + " to " + packet.getSocketAddress().toString() + " via " + this.rtcpSession.rtcpMCSock.getLocalSocketAddress().toString()));
            }
        }
        catch (Exception e) {
            System.out.println("RCTPSenderThread.MCSendCompRtcpPkt() multicast failed.");
            e.printStackTrace();
            return -1;
        }
        return packet.getLength();
    }

    protected int sendCompRtcpPkt(CompRtcpPkt pkt, InetSocketAddress receiver) {
        DatagramPacket packet;
        byte[] pktBytes = pkt.encode();
        try {
            packet = new DatagramPacket(pktBytes, pktBytes.length, receiver);
        }
        catch (Exception e) {
            System.out.println("RCTPSenderThread.SendCompRtcpPkt() packet creation failed.");
            e.printStackTrace();
            return -1;
        }
        try {
            this.rtcpSession.rtcpSock.send(packet);
            if (this.rtpSession.debugAppIntf != null) {
                this.rtpSession.debugAppIntf.packetSent(2, (InetSocketAddress)packet.getSocketAddress(), new String("Sent unicast RTCP packet of size " + packet.getLength() + " to " + packet.getSocketAddress().toString() + " via " + this.rtcpSession.rtcpSock.getLocalSocketAddress().toString()));
            }
        }
        catch (Exception e) {
            System.out.println("RTCPSenderThread.SendCompRtcpPkt() unicast failed.");
            e.printStackTrace();
            return -1;
        }
        return packet.getLength();
    }

    protected void reconsiderTiming(long ssrc) {
        Participant part = this.rtpSession.partDb.getParticipant(ssrc);
        if (part != null && this.rtcpSession.fbSendImmediately()) {
            CompRtcpPkt compPkt = this.preparePacket(part, false);
            int datagramLength = this.rtpSession.mcSession ? this.mcSendCompRtcpPkt(compPkt) : this.sendCompRtcpPkt(compPkt, part.rtcpAddress);
            if (datagramLength > 0) {
                this.rtcpSession.updateAvgPacket(datagramLength);
            }
        } else if (part != null && this.rtcpSession.fbAllowEarly && this.rtcpSession.fbSendEarly()) {
            this.rtcpSession.fbAllowEarly = false;
            CompRtcpPkt compPkt = this.preparePacket(part, true);
            int datagramLength = this.rtpSession.mcSession ? this.mcSendCompRtcpPkt(compPkt) : this.sendCompRtcpPkt(compPkt, part.rtcpAddress);
            if (datagramLength > 0) {
                this.rtcpSession.updateAvgPacket(datagramLength);
            }
            this.rtcpSession.calculateDelay();
        }
        this.rtcpSession.nextDelay = (int)((long)this.rtcpSession.nextDelay - (System.currentTimeMillis() - this.rtcpSession.prevTime));
        if (this.rtcpSession.nextDelay < 0) {
            this.rtcpSession.nextDelay = 0;
        }
    }

    protected CompRtcpPkt preparePacket(Participant part, boolean regular) {
        RtcpPktAPP[] ar;
        boolean incRR = false;
        if (part.secondLastRtcpRRPkt > part.lastRtcpRRPkt) {
            incRR = true;
            part.secondLastRtcpRRPkt = part.lastRtcpRRPkt;
            part.lastRtcpRRPkt = System.currentTimeMillis();
        }
        boolean incSR = false;
        if (this.rtpSession.sentPktCount > 0 && regular) {
            incSR = true;
        }
        CompRtcpPkt compPkt = new CompRtcpPkt();
        if (incSR) {
            RtcpPkt[] ar2;
            RtcpPktSR srPkt = new RtcpPktSR(this.rtpSession.ssrc, this.rtpSession.sentPktCount, this.rtpSession.sentOctetCount, null);
            compPkt.addPacket(srPkt);
            if (part.ssrc > 0L && (ar2 = this.rtcpSession.getFromFbQueue(part.ssrc)) != null) {
                int i = 0;
                while (i < ar2.length) {
                    compPkt.addPacket(ar2[i]);
                    ++i;
                }
            }
        }
        if (incRR || !incSR) {
            RtcpPkt[] ar3;
            Participant[] partArray = new Participant[]{part};
            if (part.receivedPkts < 1L) {
                partArray = null;
            }
            RtcpPktRR rrPkt = new RtcpPktRR(partArray, this.rtpSession.ssrc);
            compPkt.addPacket(rrPkt);
            if (!incSR && part.ssrc > 0L && (ar3 = this.rtcpSession.getFromFbQueue(part.ssrc)) != null) {
                int i = 0;
                while (i < ar3.length) {
                    compPkt.addPacket(ar3[i]);
                    ++i;
                }
            }
        }
        if (regular && part.ssrc > 0L && (ar = this.rtcpSession.getFromAppQueue(part.ssrc)) != null) {
            int i = 0;
            while (i < ar.length) {
                compPkt.addPacket(ar[i]);
                ++i;
            }
        }
        RtcpPktSDES sdesPkt = new RtcpPktSDES(true, this.rtpSession, null);
        compPkt.addPacket(sdesPkt);
        return compPkt;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            System.out.println("RTCPSenderThread didn't get any initial rest.");
        }
        Enumeration enu = null;
        Iterator iter = null;
        if (this.rtpSession.mcSession) {
            enu = this.rtpSession.partDb.getParticipants();
        } else {
            iter = this.rtpSession.partDb.getUnicastReceivers();
        }
        while (!this.rtpSession.endSession) {
            block16: {
                try {
                    Thread.sleep(this.rtcpSession.nextDelay);
                }
                catch (Exception e) {
                    System.out.println("RTCPSenderThread Exception message:" + e.getMessage());
                    if (this.rtpSession.endSession) continue;
                    if (this.rtcpSession.fbWaiting == -1L) break block16;
                    this.reconsiderTiming(this.rtcpSession.fbWaiting);
                    continue;
                }
            }
            this.rtcpSession.fbAllowEarly = true;
            this.rtcpSession.calculateDelay();
            if (this.rtpSession.conflict) {
                if (this.byesSent) continue;
                this.sendByes();
                this.byesSent = true;
                continue;
            }
            this.byesSent = false;
            Participant part = null;
            if (this.rtpSession.mcSession) {
                if (!enu.hasMoreElements()) {
                    enu = this.rtpSession.partDb.getParticipants();
                }
                if (!enu.hasMoreElements()) continue;
                part = (Participant)enu.nextElement();
            } else {
                if (!iter.hasNext()) {
                    iter = this.rtpSession.partDb.getUnicastReceivers();
                }
                if (iter.hasNext()) {
                    while (iter.hasNext() && (part == null || part.rtcpAddress == null)) {
                        part = (Participant)iter.next();
                    }
                }
                if (part == null || part.rtcpAddress == null) continue;
            }
            CompRtcpPkt compPkt = this.preparePacket(part, true);
            int datagramLength = this.rtpSession.mcSession ? this.mcSendCompRtcpPkt(compPkt) : this.sendCompRtcpPkt(compPkt, part.rtcpAddress);
            if (datagramLength <= 0) continue;
            this.rtcpSession.updateAvgPacket(datagramLength);
        }
        this.sendByes();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

