package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.beem.project.beem.R;
import com.beem.project.beem.service.Contact;

public class ContactDialog extends Dialog {

    private Contact mContact;
    private Context mContext;

    public ContactDialog(final Context context, Contact curContact) {
	super(context);
	mContext = context;
	setContentView(R.layout.contactdialog);
	mContact = curContact;
	setTitle(curContact.getJID());

	Button chat = (Button) findViewById(R.id.CDChat);
	chat.setOnClickListener(new chatListener());
	Button alias= (Button) findViewById(R.id.CDAlias);
	alias.setOnClickListener(new aliasListener());
	Button group = (Button) findViewById(R.id.CDGroup);
	group.setOnClickListener(new groupListener());
	Button resend = (Button) findViewById(R.id.CDResend);
	resend.setOnClickListener(new resendListener());
	Button infos = (Button) findViewById(R.id.CDInfos);
	infos.setOnClickListener(new infosListener());
    }

    class chatListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    Activity a = ContactDialog.this.getOwnerActivity();
	    Intent i = new Intent(mContext, SendIM.class);
	    i.setData(mContact.toUri());
	    a.startActivity(i);
	    dismiss();
	}

    }

    class aliasListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    // TODO Auto-generated method stub
	    dismiss();
	}
	
    }
    
    class groupListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    // TODO Auto-generated method stub
	    dismiss();
	}
	
    }
    
    class resendListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    // TODO Auto-generated method stub
	    dismiss();
	}
	
    }
    
    class infosListener implements View.OnClickListener {

	@Override
	public void onClick(View v) {
	    // TODO Auto-generated method stub
	    dismiss();
	}
	
    }

}
