/**
 * 
 */
package com.beem.project.beem.service;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smack.PrivacyListListener;
import org.jivesoftware.smack.PrivacyListManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.PrivacyItem;
import org.jivesoftware.smack.packet.PrivacyItem.PrivacyRule;

import android.os.RemoteException;
import android.util.Log;

import com.beem.project.beem.service.aidl.IPrivacyListManager;

/**
 * @author nikita
 *
 */
public class PrivacyListManagerAdapter extends IPrivacyListManager.Stub {
    public static final String TAG = "PrivacyListManagerAdapter";
    private PrivacyListManager mAdaptee = null;
    private List<String> mBlockedUser = new ArrayList<String>();
    private XMPPConnection mConnection;
    private MyPrivacyListListener privacyPacketListener = new MyPrivacyListListener();

    public PrivacyListManagerAdapter(XMPPConnection connection) {
	mConnection = connection;
	mAdaptee = PrivacyListManager.getInstanceFor(mConnection);
	mAdaptee.addListener(privacyPacketListener);
    }

    public List<String> getBlockedUsers() {
	return mBlockedUser;
    }

    public synchronized void addBlockedUser(String jid) {
	if (mAdaptee == null) {
	    mAdaptee = PrivacyListManager.getInstanceFor(mConnection);
	    mAdaptee.addListener(privacyPacketListener);
	}
	List<PrivacyItem> pItemList = new ArrayList<PrivacyItem>();
	PrivacyItem pItem = new PrivacyItem("jid", true, 1);
	pItem.setFilterMessage(true);
	pItem.setValue(jid);	
	pItemList.add(pItem);

	pItem = new PrivacyItem("subscription", true, 2);
	pItem.setValue(PrivacyRule.SUBSCRIPTION_BOTH);
	pItemList.add(pItem);

	try {
	    if (mAdaptee.getPrivacyList("default") == null) {

	    }

	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	} catch (ClassCastException e) {
	    e.printStackTrace();
	    try {
		mAdaptee.createPrivacyList("default", pItemList);
	    } catch (XMPPException e1) {
		// TODO Auto-generated catch block
		e1.printStackTrace();
	    }
	}
	try {
	    mAdaptee.setActiveListName("default");
	    mAdaptee.setDefaultListName("default");
	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}

	Log.d(TAG, "addBlockedUser");
    }

    class MyPrivacyListListener implements PrivacyListListener {

	@Override
	public void setPrivacyList(String listName, List<PrivacyItem> listItem) {
	    Log.d(TAG,"setPrivacyList");
	}

	@Override
	public void updatedPrivacyList(String listName) {
	    Log.d(TAG,"updatedPrivacyList");
	}	
    }

    @Override
    public List<String> getBlockedUsersByList(String listName) throws RemoteException {
	// TODO Auto-generated method stub
	return null;
    }

    public PrivacyListManager getManager() {
	return mAdaptee;
    }   
}
