/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import sun.misc.CharacterEncoder;

public class HexDumpEncoder
extends CharacterEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    static void hexDigit(PrintStream p, byte x) {
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        p.write(c);
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        p.write(c);
    }

    @Override
    protected int bytesPerAtom() {
        return 1;
    }

    @Override
    protected int bytesPerLine() {
        return 16;
    }

    @Override
    protected void encodeBufferPrefix(OutputStream o) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(o);
    }

    @Override
    protected void encodeLinePrefix(OutputStream o, int len) throws IOException {
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset & 0xFF));
        this.pStream.print(": ");
        this.currentByte = 0;
        this.thisLineLength = len;
    }

    @Override
    protected void encodeAtom(OutputStream o, byte[] buf, int off, int len) throws IOException {
        this.thisLine[this.currentByte] = buf[off];
        HexDumpEncoder.hexDigit(this.pStream, buf[off]);
        this.pStream.print(" ");
        ++this.currentByte;
        if (this.currentByte == 8) {
            this.pStream.print("  ");
        }
    }

    @Override
    protected void encodeLineSuffix(OutputStream o) throws IOException {
        int i;
        if (this.thisLineLength < 16) {
            i = this.thisLineLength;
            while (i < 16) {
                this.pStream.print("   ");
                if (i == 7) {
                    this.pStream.print("  ");
                }
                ++i;
            }
        }
        this.pStream.print(" ");
        i = 0;
        while (i < this.thisLineLength) {
            if (this.thisLine[i] < 32 || this.thisLine[i] > 122) {
                this.pStream.print(".");
            } else {
                this.pStream.write(this.thisLine[i]);
            }
            ++i;
        }
        this.pStream.println();
        this.offset += this.thisLineLength;
    }
}

