package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.R;

/**
 *
 */
public class ContactListDialogSettings extends Dialog implements
	android.view.View.OnClickListener {

    private SharedPreferences mSettings;

    public ContactListDialogSettings(Activity activity,
	    SharedPreferences settings) {
	super(activity);
	this.mSettings = settings;
    }

    @Override
    protected void onStart() {
	super.onStart();
	setContentView(R.layout.contactlistdialogsettings);
	getWindow().setFlags(4, 4);
	setTitle("Jabber Account Settings");
	Button ok = (Button) findViewById(R.id.ok);
	ok.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
	SharedPreferences.Editor editor = mSettings.edit();
	Context ctx = getContext();
	editor.putString(ctx.getString(R.string.PreferenceHostKey),
		getWidgetText(R.id.host));
	editor.putString(ctx.getString(R.string.PreferencePortKey),
		getWidgetText(R.id.port));
	editor.putString(ctx.getString(R.string.PreferenceLoginKey),
		getWidgetText(R.id.userid));
	editor.putString(ctx.getString(R.string.PreferencePasswordKey),
		getWidgetText(R.id.password));
	String JID = ctx.getString(R.string.PreferenceLoginKey) + "@"
		+ ctx.getString(R.string.PreferenceHostKey);
	editor.putString(ctx.getString(R.string.PreferenceJID), JID);
	editor.putBoolean("ACCOUNT_CONFIGURED", true);
	editor.commit();
	dismiss();
    }



    private String getWidgetText(int id) {
	EditText widget = (EditText) this.findViewById(id);
	return widget.getText().toString();
    }
}
