/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.mediaimpl.sshare.api;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.DefaultEncoder;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.ImageEncoder;
import org.jivesoftware.smackx.jingle.mediaimpl.sshare.api.QuantizeFilter;

public class ImageTransmitter
implements Runnable {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(ImageTransmitter.class);
    private Robot robot;
    private InetAddress localHost;
    private InetAddress remoteHost;
    private int localPort;
    private int remotePort;
    public static final int tileWidth = 25;
    private boolean on = true;
    private boolean transmit = false;
    private DatagramSocket socket;
    private Rectangle area;
    private int[][][] tiles;
    private int maxI;
    private int maxJ;
    private ImageEncoder encoder;
    public static final int KEYFRAME = 10;

    public ImageTransmitter(DatagramSocket socket, InetAddress remoteHost, int remotePort, Rectangle area) {
        try {
            this.robot = new Robot();
            this.maxI = (int)Math.ceil(area.getWidth() / 25.0);
            this.maxJ = (int)Math.ceil(area.getHeight() / 25.0);
            this.tiles = new int[this.maxI][this.maxJ][625];
            this.area = area;
            this.socket = socket;
            this.localHost = socket.getLocalAddress();
            this.localPort = socket.getLocalPort();
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.encoder = new DefaultEncoder();
            this.transmit = true;
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        byte[] buf = new byte[1024];
        DatagramPacket p = new DatagramPacket(buf, 1024);
        int keyframe = 0;
        while (this.on) {
            if (!this.transmit) continue;
            BufferedImage capture = this.robot.createScreenCapture(this.area);
            QuantizeFilter filter = new QuantizeFilter();
            capture = filter.filter(capture, null);
            long trace = System.currentTimeMillis();
            if (++keyframe > 10) {
                keyframe = 0;
            }
            LOGGER.debug("KEYFRAME:" + keyframe);
            for (int i = 0; i < this.maxI; ++i) {
                for (int j = 0; j < this.maxJ; ++j) {
                    BufferedImage bufferedImage = capture.getSubimage(i * 25, j * 25, 25, 25);
                    int[] pixels = new int[625];
                    PixelGrabber pg = new PixelGrabber(bufferedImage, 0, 0, 25, 25, pixels, 0, 25);
                    try {
                        ByteArrayOutputStream baos;
                        if (!pg.grabPixels() || keyframe != 10 && Arrays.equals(this.tiles[i][j], pixels) || (baos = this.encoder.encode(bufferedImage)) == null) continue;
                        try {
                            Thread.sleep(1L);
                            baos.write(i);
                            baos.write(j);
                            byte[] bytesOut = baos.toByteArray();
                            if (bytesOut.length > 1000) {
                                LOGGER.error("Bytes out > 1000. Equals " + bytesOut.length);
                            }
                            p.setData(bytesOut);
                            p.setAddress(this.remoteHost);
                            p.setPort(this.remotePort);
                            try {
                                this.socket.send(p);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            this.tiles[i][j] = pixels;
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            trace = System.currentTimeMillis() - trace;
            LOGGER.debug("Loop Time:" + trace);
            if (trace >= 500L) continue;
            try {
                Thread.sleep(500L - trace);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        this.start();
    }

    public void setTransmit(boolean transmit) {
        this.transmit = transmit;
    }

    public ImageEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(ImageEncoder encoder) {
        this.encoder = encoder;
    }

    public void stop() {
        this.transmit = false;
        this.on = false;
        this.socket.close();
    }
}

