package com.beem.project.beem.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.app.ExpandableListActivity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.widget.ExpandableListAdapter;
import android.widget.SimpleExpandableListAdapter;

import com.beem.project.beem.BeemService;
import com.beem.project.beem.R;
import com.beem.project.beem.service.IXMPPFacade;

public class ContactList extends ExpandableListActivity {

    private IXMPPFacade mService = null;

    @Override
    public void onCreate(Bundle saveBundle) {
        super.onCreate(saveBundle);
        bindService(new Intent(this, BeemService.class), mConnection,
                BIND_AUTO_CREATE | BIND_DEBUG_UNBIND);
        showContactList();
    }

    private void showContactList() {
        ExpandableListAdapter Adapter;
        
        List<Map<String, String>> groupData = new ArrayList<Map<String, String>>();
        List<List<Map<String, String>>> childData = new ArrayList<List<Map<String, String>>>();

        for (int i = 0; i < 2; i++) {
            Map<String, String> curGroupMap = new HashMap<String, String>();
            groupData.add(curGroupMap);
            curGroupMap.put("NAME", "Group " + i);
            
            List<Map<String, String>> children = new ArrayList<Map<String, String>>();
            for (int j = 0; j < 5; j++) {
                Map<String, String> curChildMap = new HashMap<String, String>();
                children.add(curChildMap);
                curChildMap.put("NAME CHILD", "Child " + j);                
            }
            childData.add(children);
        }

        Adapter = new SimpleExpandableListAdapter(this, 
                groupData, R.layout.contactlistgroup,
                new String[] {"NAME"}, new int[] {R.id.textgroup},
                childData, R.layout.contactlist,
                new String[] {"NAME CHILD"}, new int[] {R.id.textchild});
        setListAdapter(Adapter);
    }

    private ServiceConnection mConnection = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            mService = IXMPPFacade.Stub.asInterface(service);
            /*
             * mService.getGroupList(); mService.getContactList();
             */
            showContactList();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }

    };

    @Override
    public void onDestroy() {
        super.onDestroy();
        unbindService(mConnection);
    }

}
