/**
 * 
 */
package com.beem.project.beem.utils;

import org.jivesoftware.smack.packet.Presence;

/**
 * @author nikita
 *
 */
public class PresenceType {

    /**
     * The user is available to receive messages (default).
     */
    public static final int AVAILABLE = 100;

    /**
     * The user is unavailable to receive messages.
     */
    public static final int UNAVAILABLE = 200;

    /**
     * Request subscription to recipient's presence.
     */

    public static final int SUBSCRIBE = 300;

    /**
     * Grant subscription to sender's presence.
     */
    public static final int SUBSCRIBED = 400;

    /**
     * Request removal of subscription to sender's presence.
     */
    public static final int UNSUBSCRIBE = 500;

    /**
     * Grant removal of subscription to sender's presence.
     */
    public static final int UNSUBSCRIBED = 600;

    /**
     * The presence packet contains an error message.
     */
    public static final int ERROR = 701;

    /**
     * Get the presence type from a presence packet.
     * @param presence the presence type
     */
    public static int getPresenceType(Presence presence) {
	int res = PresenceType.ERROR;
	switch (presence.getType()) {
	    case available:
		res = PresenceType.AVAILABLE;
		break;
	    case unavailable:
		res = PresenceType.UNAVAILABLE;
		break;
	    case subscribe:
		res = PresenceType.SUBSCRIBE;
		break;
	    case subscribed:
		res = PresenceType.SUBSCRIBED;
		break;
	    case unsubscribe:
		res = PresenceType.UNSUBSCRIBE;
		break;
	    case unsubscribed:
		res = PresenceType.UNSUBSCRIBED;
		break;
	    case error:
	    default:
		res = PresenceType.ERROR;
	};
	return res;
    }
    
    /**
     * Get the smack presence mode for a status
     * @param status the status in beem
     * @return the presence mode to use in presence packet
     * 		or null if there is no mode to use
     */
    public static Presence.Type getPresenceTypeFrom(int type){
	Presence.Type res;
	switch (type) {
	    case AVAILABLE:
		res = Presence.Type.available;
		break;
	    case UNAVAILABLE:
		res = Presence.Type.unavailable;		
		break;
	    case SUBSCRIBE:
		res = Presence.Type.subscribe;
		break;
	    case SUBSCRIBED:
		res = Presence.Type.subscribed;
		break;
	    case UNSUBSCRIBE:
		res = Presence.Type.unsubscribe;
		break;
	    case UNSUBSCRIBED:
		res = Presence.Type.unsubscribed;
		break;
	    case ERROR:
		res = Presence.Type.error;
		break;
	    default:
		return null;
	}
	return res;
    }
}
