package com.beem.project.beem.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ComponentName;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;

import com.beem.project.beem.R;
import com.beem.project.beem.service.aidl.IBeemConnectionListener;
import com.beem.project.beem.service.aidl.IXmppConnection;
import com.beem.project.beem.service.aidl.IXmppFacade;
import com.beem.project.beem.utils.Status;

/**
 * This class represents an activity which allows the user to connect to an XMPP server with his username/password.
 * @author dasilvj
 */
public class Login extends Activity {

    // private static final String TAG = "LOG_AS";
    private static final Intent SERVICE_INTENT = new Intent();
    static {
	SERVICE_INTENT.setComponent(new ComponentName("com.beem.project.beem", "com.beem.project.beem.BeemService"));
    }

    private final Handler mConnectionHandler = new Handler();
    private ProgressDialog mProgressDialog;

    private boolean mIsConnected;
    private final ServiceConnection mServConn = new BeemServiceConnection();
    private IXmppFacade mXmppFacade;

    private SharedPreferences mSettings;
    private boolean mIsConfigured;

    /**
     * Constructor.
     */
    public Login() {
    }

    /**
     * Create an about "BEEM" dialog.
     */
    public void createAboutDialog() {
	AlertDialog.Builder builder = new AlertDialog.Builder(this);
	builder.setTitle(R.string.login_about_title).setMessage(R.string.login_about_msg).setCancelable(false);
	builder.setNeutralButton(R.string.login_about_button, new DialogInterface.OnClickListener() {

	    public void onClick(DialogInterface dialog, int whichButton) {
		dialog.cancel();
	    }
	});
	AlertDialog aboutDialog = builder.create();
	aboutDialog.show();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	mSettings = getSharedPreferences(getString(R.string.settings_filename), MODE_PRIVATE);
	setContentView(R.layout.login);
	mProgressDialog = new ProgressDialog(this);
    }

    @Override
    protected void onDestroy() {
	super.onDestroy();
	if (mIsConfigured && (mIsConnected || mXmppFacade != null)) {
	    unbindService(mServConn);
	}
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onStart() {
	super.onStart();
	mIsConfigured = mSettings.getBoolean(getString(R.string.PreferenceIsConfigured), false);

	if (mIsConfigured)
	    bindService(Login.SERVICE_INTENT, mServConn, BIND_AUTO_CREATE);

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
	super.onCreateOptionsMenu(menu);
	MenuInflater inflater = getMenuInflater();
	inflater.inflate(R.menu.login, menu);
	return true;
    }

    /**
     * Callback for menu item selected.
     * @param item the item selected
     * @return true on success, false otherwise
     */
    @Override
    public final boolean onOptionsItemSelected(MenuItem item) {
	switch (item.getItemId()) {
	    case R.id.login_menu_settings:
		startActivity(new Intent(Login.this, EditSettings.class));
		return true;
	    case R.id.login_menu_about:
		createAboutDialog();
		return true;
	    default:
		return false;
	}
    }

    /**
     * Listener use to check the state of the connection with the server.
     */
    private class BeemConnectionListener extends IBeemConnectionListener.Stub {

	/**
	 * Constructor.
	 */
	public BeemConnectionListener() {
	}

	/**
	 * Runnable to display error message.
	 */
	private class ErrorRunnable implements Runnable {

	    private final String mErrorMsg;

	    /**
	     * Constructor.
	     * @param errorMsg The message to display.
	     */
	    public ErrorRunnable(final String errorMsg) {
		mErrorMsg = errorMsg;
	    }

	    /**
	     * {@inheritDoc}
	     */
	    @Override
	    public void run() {
		mProgressDialog.setMessage(mErrorMsg);
	    }

	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void connectionClosed() throws RemoteException {
	    mIsConnected = false;
	    if (mXmppFacade != null) {
		mXmppFacade = null;
	    }
	}

	@Override
	public void connectionClosedOnError() throws RemoteException {
	}

	@Override
	public void connectionFailed(String errorMsg) throws RemoteException {
	    Log.e("Login", "CONNECTIONFAILLED");
	    mIsConnected = false;
	    if (mXmppFacade != null) {
		Login.this.unbindService(mServConn);
		Login.this.stopService(SERVICE_INTENT);
		mXmppFacade = null;
	    }
	    mConnectionHandler.post(new ErrorRunnable(errorMsg));
	    dismissProgressDialog();
	    showToast(errorMsg);
	}

	/**
	 * Show an error message with a toast.
	 * @param errorMsg The message to display.
	 */
	private void showToast(final String errorMsg) {
	    mConnectionHandler.post(new Runnable() {
		/**
		 * @{inheritDoc
		 */
		@Override
		public void run() {
		    Toast.makeText(Login.this, errorMsg, Toast.LENGTH_LONG).show();
		    TextView labelError = (TextView) findViewById(R.id.log_as_msg);
		    labelError.setText(getString(R.string.login_error_msg, errorMsg));
		}
	    });
	}

	/**
	 * Dismiss the progress dialog.
	 */
	private void dismissProgressDialog() {
	    mConnectionHandler.post(new Runnable() {

		/**
		 * @{inheritDoc
		 */
		@Override
		public void run() {
		    mProgressDialog.dismiss();
		}
	    });
	}

	@Override
	public void onConnect() throws RemoteException {
	    mIsConnected = true;
	    dismissProgressDialog();
	    Log.i(getString(R.string.login_tag), "Connected.");
	    mXmppFacade.changeStatus(Status.CONTACT_STATUS_AVAILABLE, null);
	    startActivity(new Intent(Login.this, ContactList.class));
	    finish();
	}

	@Override
	public void reconnectingIn(int seconds) throws RemoteException {
	    mIsConnected = true;

	}

	@Override
	public void reconnectionFailed() throws RemoteException {
	    mIsConnected = false;
	}

	@Override
	public void reconnectionSuccessful() throws RemoteException {
	    mIsConnected = true;
	}
    }

    /**
     * ServiceConnection use to connect to the Beem Service.
     */
    private class BeemServiceConnection implements ServiceConnection {
	private IXmppConnection mXmppConnection;

	/**
	 * Constructor.
	 */
	public BeemServiceConnection() {
	}

	@Override
	public void onServiceConnected(ComponentName name, IBinder service) {
	    mIsConnected = true;
	    mXmppFacade = IXmppFacade.Stub.asInterface(service);
	    try {
		mXmppConnection = mXmppFacade.createConnection();
		mXmppConnection.addConnectionListener(new BeemConnectionListener());
		if (!mXmppConnection.isAuthentificated()) {
		    mConnectionHandler.post(new Runnable() {

			@Override
			public void run() {
			    mProgressDialog.setMessage(getString(R.string.login_login_progress));
			    mProgressDialog.show();
			}
		    });
		    Login.this.startService(Login.SERVICE_INTENT);
		} else {
		    startActivity(new Intent(Login.this, ContactList.class));
		    finish();
		}
	    } catch (RemoteException e) {
		Log.e(getString(R.string.login_tag), "REMOTE EXCEPTION $" + e.getMessage());
	    }
	}

	@Override
	public void onServiceDisconnected(ComponentName name) {
	    mIsConnected = false;
	    mXmppFacade = null;
	}
    }    
}
