/**
 * 
 */
package com.beem.project.beem.ui;

import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Presence.Type;

import com.beem.project.beem.BeemApplication;
import com.beem.project.beem.R;
import com.beem.project.beem.service.PresenceAdapter;
import com.beem.project.beem.service.aidl.IXmppFacade;

import android.app.Activity;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Toast;

/**
 * @author nikita
 *
 */
public class Subscription extends Activity {
    
    private IXmppFacade mService;
    private String mContact;
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.subscription);
	findViewById(R.id.SubscriptionAccept).setOnClickListener(mClickListener);
	findViewById(R.id.SubscriptionRefuse).setOnClickListener(mClickListener);
	mContact = getIntent().getStringExtra("from");
	mService = BeemApplication.getApplication(this).getXmppFacade();
    }
    
    private OnClickListener mClickListener = new OnClickListener() {

	@Override
	public void onClick(View v) {
	    switch (v.getId()) {
		case R.id.SubscriptionAccept:
		    Presence presence = new Presence(Type.subscribed);
		    presence.setTo(mContact);
		    PresenceAdapter preAdapt = new PresenceAdapter(presence);
		    try {
			mService.sendPresencePacket(preAdapt);
			Toast.makeText(Subscription.this, "Subscription accept",
	                    Toast.LENGTH_SHORT).show();
			finish();
		    } catch (RemoteException e) {
			Toast.makeText(Subscription.this, "Subscription error",
	                    Toast.LENGTH_SHORT).show();
			e.printStackTrace();
		    }
		    break ;
		case R.id.SubscriptionRefuse:
		    Toast.makeText(Subscription.this, "Subscription refused",
	                    Toast.LENGTH_SHORT).show();
		    
		    break ;
		default:
		    Toast.makeText(Subscription.this, "Subscription error",
	                    Toast.LENGTH_SHORT).show();
	    };
	    
	}
	
    };
}
