/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.IBBExtensions;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class IBBTransferNegotiator
extends StreamNegotiator {
    protected static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    private XMPPConnection connection;

    protected IBBTransferNegotiator(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    public PacketFilter getInitiationPacketFilter(String string, String string2) {
        return new AndFilter(new FromContainsFilter(string), new IBBOpenSidFilter(string2));
    }

    InputStream negotiateIncomingStream(Packet packet) throws XMPPException {
        IBBExtensions.Open open = (IBBExtensions.Open)packet;
        if (open.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException(open.getError());
        }
        IBBMessageSidFilter iBBMessageSidFilter = new IBBMessageSidFilter(open.getFrom(), open.getSessionID());
        AndFilter andFilter = new AndFilter(new PacketTypeFilter(IBBExtensions.Close.class), new FromMatchesFilter(open.getFrom()));
        IBBInputStream iBBInputStream = new IBBInputStream(open.getSessionID(), iBBMessageSidFilter, andFilter);
        this.initInBandTransfer(open);
        return iBBInputStream;
    }

    public InputStream createIncomingStream(StreamInitiation streamInitiation) throws XMPPException {
        Packet packet = this.initiateIncomingStream(this.connection, streamInitiation);
        return this.negotiateIncomingStream(packet);
    }

    private void initInBandTransfer(IBBExtensions.Open open) {
        this.connection.sendPacket(FileTransferNegotiator.createIQ(open.getPacketID(), open.getFrom(), open.getTo(), IQ.Type.RESULT));
    }

    public OutputStream createOutgoingStream(String string, String string2, String string3) throws XMPPException {
        IBBExtensions.Open open = new IBBExtensions.Open(string, 4096);
        open.setTo(string3);
        open.setType(IQ.Type.SET);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(open.getPacketID()));
        this.connection.sendPacket(open);
        IQ iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (iQ == null) {
            throw new XMPPException("No response from peer on IBB open");
        }
        IQ.Type type = iQ.getType();
        if (!type.equals(IQ.Type.RESULT)) {
            if (type.equals(IQ.Type.ERROR)) {
                throw new XMPPException("Target returned an error", iQ.getError());
            }
            throw new XMPPException("Target returned unknown response");
        }
        return new IBBOutputStream(string3, string, 4096);
    }

    public String[] getNamespaces() {
        return new String[]{NAMESPACE};
    }

    public void cleanup() {
    }

    private static class IBBMessageSidFilter
    implements PacketFilter {
        private final String sessionID;
        private String from;

        public IBBMessageSidFilter(String string, String string2) {
            this.from = string;
            this.sessionID = string2;
        }

        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            if (!packet.getFrom().equalsIgnoreCase(this.from)) {
                return false;
            }
            IBBExtensions.Data data = (IBBExtensions.Data)packet.getExtension("data", IBBTransferNegotiator.NAMESPACE);
            return data != null && data.getSessionID() != null && data.getSessionID().equalsIgnoreCase(this.sessionID);
        }
    }

    private static class IBBOpenSidFilter
    implements PacketFilter {
        private String sessionID;

        public IBBOpenSidFilter(String string) {
            if (string == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = string;
        }

        public boolean accept(Packet packet) {
            if (!IBBExtensions.Open.class.isInstance(packet)) {
                return false;
            }
            IBBExtensions.Open open = (IBBExtensions.Open)packet;
            String string = open.getSessionID();
            return string != null && string.equals(this.sessionID);
        }
    }

    private class IBBInputStream
    extends InputStream
    implements PacketListener {
        private String streamID;
        private PacketCollector dataCollector;
        private byte[] buffer;
        private int bufferPointer;
        private int seq = -1;
        private boolean isDone;
        private boolean isEOF;
        private boolean isClosed;
        private IQ closeConfirmation;
        private Message lastMess;

        private IBBInputStream(String string, PacketFilter packetFilter, PacketFilter packetFilter2) {
            this.streamID = string;
            this.dataCollector = IBBTransferNegotiator.this.connection.createPacketCollector(packetFilter);
            IBBTransferNegotiator.this.connection.addPacketListener(this, packetFilter2);
            this.bufferPointer = -1;
        }

        public synchronized int read() throws IOException {
            if (this.isEOF || this.isClosed) {
                return -1;
            }
            if (this.bufferPointer == -1 || this.bufferPointer >= this.buffer.length) {
                this.loadBufferWait();
            }
            return this.buffer[this.bufferPointer++];
        }

        public synchronized int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.isEOF || this.isClosed) {
                return -1;
            }
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBufferWait())) {
                this.isEOF = true;
                return -1;
            }
            if (n2 - n > this.buffer.length - this.bufferPointer) {
                n2 = this.buffer.length - this.bufferPointer;
            }
            System.arraycopy(this.buffer, this.bufferPointer, byArray, n, n2);
            this.bufferPointer += n2;
            return n2;
        }

        private boolean loadBufferWait() throws IOException {
            Packet packet = null;
            while (packet == null) {
                if (this.isDone) {
                    packet = (Message)this.dataCollector.pollResult();
                    if (packet != null) continue;
                    return false;
                }
                packet = (Message)this.dataCollector.nextResult(1000L);
            }
            this.lastMess = packet;
            IBBExtensions.Data data = (IBBExtensions.Data)packet.getExtension("data", IBBTransferNegotiator.NAMESPACE);
            this.checkSequence((Message)packet, (int)data.getSeq());
            this.buffer = StringUtils.decodeBase64(data.getData());
            this.bufferPointer = 0;
            return true;
        }

        private void checkSequence(Message message, int n) throws IOException {
            if (this.seq == 65535) {
                this.seq = -1;
            }
            if (n - 1 != this.seq) {
                this.cancelTransfer(message);
                throw new IOException("Packets out of sequence");
            }
            this.seq = n;
        }

        private void cancelTransfer(Message message) {
            this.cleanup();
            this.sendCancelMessage(message);
        }

        private void cleanup() {
            this.dataCollector.cancel();
            IBBTransferNegotiator.this.connection.removePacketListener(this);
        }

        private void sendCancelMessage(Message message) {
            IQ iQ = FileTransferNegotiator.createIQ(message.getPacketID(), message.getFrom(), message.getTo(), IQ.Type.ERROR);
            iQ.setError(new XMPPError(XMPPError.Condition.remote_server_timeout, "Cancel Message Transfer"));
            IBBTransferNegotiator.this.connection.sendPacket(iQ);
        }

        public boolean markSupported() {
            return false;
        }

        public void processPacket(Packet packet) {
            IBBExtensions.Close close = (IBBExtensions.Close)packet;
            if (close.getSessionID().equals(this.streamID)) {
                this.isDone = true;
                this.closeConfirmation = FileTransferNegotiator.createIQ(packet.getPacketID(), packet.getFrom(), packet.getTo(), IQ.Type.RESULT);
            }
        }

        public synchronized void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.cleanup();
            if (this.isEOF) {
                this.sendCloseConfirmation();
            } else if (this.lastMess != null) {
                this.sendCancelMessage(this.lastMess);
            }
            this.isClosed = true;
        }

        private void sendCloseConfirmation() {
            IBBTransferNegotiator.this.connection.sendPacket(this.closeConfirmation);
        }
    }

    private class IBBOutputStream
    extends OutputStream {
        protected byte[] buffer;
        protected int count = 0;
        protected int seq = 0;
        final String userID;
        private final IQ closePacket;
        private String messageID;
        private String sid;

        IBBOutputStream(String string, String string2, int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.buffer = new byte[n];
            this.userID = string;
            Message message = new Message(string);
            this.messageID = message.getPacketID();
            this.sid = string2;
            this.closePacket = this.createClosePacket(string, string2);
        }

        private IQ createClosePacket(String string, String string2) {
            IBBExtensions.Close close = new IBBExtensions.Close(string2);
            close.setTo(string);
            close.setType(IQ.Type.SET);
            return close;
        }

        public void write(int n) throws IOException {
            if (this.count >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.count++] = (byte)n;
        }

        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 >= this.buffer.length) {
                this.writeOut(byArray, n, this.buffer.length);
                this.write(byArray, n + this.buffer.length, n2 - this.buffer.length);
            } else {
                this.writeOut(byArray, n, n2);
            }
        }

        private void writeOut(byte[] byArray, int n, int n2) {
            if (n2 > this.buffer.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(byArray, n, this.buffer, this.count, n2);
            this.count += n2;
        }

        private synchronized void flushBuffer() {
            this.writeToXML(this.buffer, 0, this.count);
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void writeToXML(byte[] byArray, int n, int n2) {
            Message message = this.createTemplate(this.messageID + "_" + this.seq);
            IBBExtensions.Data data = new IBBExtensions.Data(this.sid);
            message.addExtension(data);
            String string = StringUtils.encodeBase64(byArray, n, n2, false);
            data.setData(string);
            data.setSeq(this.seq);
            IBBOutputStream iBBOutputStream = this;
            synchronized (iBBOutputStream) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            IBBTransferNegotiator.this.connection.sendPacket(message);
            this.seq = this.seq + 1 == 65535 ? 0 : this.seq + 1;
        }

        public void close() throws IOException {
            this.flush();
            IBBTransferNegotiator.this.connection.sendPacket(this.closePacket);
        }

        public void flush() throws IOException {
            this.flushBuffer();
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public Message createTemplate(String string) {
            Message message = new Message(this.userID);
            message.setPacketID(string);
            return message;
        }
    }
}

