package com.beem.project.beem.service;

import org.jivesoftware.smack.packet.Presence;

import com.beem.project.beem.utils.PresenceType;
import com.beem.project.beem.utils.Status;

import android.os.Parcel;
import android.os.Parcelable;

public class PresenceAdapter implements  Parcelable {
	
	private int mType;
	private int mStatus;
	private String mTo;
	private String mFrom;
	private String mStatusText;
	
	/**
	 * Parcelable.Creator needs by Android.
	 */
	public static final Parcelable.Creator<PresenceAdapter> CREATOR = new Parcelable.Creator<PresenceAdapter>() {

		@Override
		public PresenceAdapter createFromParcel(Parcel source) {
			return new PresenceAdapter(source);
		}

		@Override
		public PresenceAdapter[] newArray(int size) {
			return new PresenceAdapter[size];
		}
	};
	
	public PresenceAdapter(Presence presence) {
		mType = PresenceType.getPresenceType(presence);
		mStatus = Status.getStatusFromPresence(presence);
		mTo = presence.getTo();
		mFrom = presence.getFrom();
		mStatusText = presence.getStatus();
	}
	
	
	public PresenceAdapter(Parcel source) {
		mType = source.readInt();
		mStatus = source.readInt();
		mTo = source.readString();
		mFrom = source.readString();
		mStatusText = source.readString();
	}

	@Override
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(mType);
		dest.writeInt(mStatus);
		dest.writeString(mTo);
		dest.writeString(mFrom);
		dest.writeString(mStatusText);
	}


	/**
	 * @param mStatus the mStatus to set
	 */
	public void setStatus(int mStatus) {
	    this.mStatus = mStatus;
	}


	/**
	 * @return the mStatus
	 */
	public int getStatus() {
	    return mStatus;
	}


	/**
	 * @param mType the mType to set
	 */
	public void setType(int mType) {
	    this.mType = mType;
	}


	/**
	 * @return the mType
	 */
	public int getType() {
	    return mType;
	}


	/**
	 * @param mTo the mTo to set
	 */
	public void setTo(String mTo) {
	    this.mTo = mTo;
	}

	/**
	 * @return the mTo
	 */
	public String getTo() {
	    return mTo;
	}


	/**
	 * @param mFrom the mFrom to set
	 */
	public void setFrom(String mFrom) {
	    this.mFrom = mFrom;
	}


	/**
	 * @return the mFrom
	 */
	public String getFrom() {
	    return mFrom;
	}


	/**
	 * @param mStatusText the mStatusText to set
	 */
	public void setStatusText(String mStatusText) {
	    this.mStatusText = mStatusText;
	}


	/**
	 * @return the mStatusText
	 */
	public String getStatusText() {
	    return mStatusText;
	}
}
