/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.packet.JingleDescription;
import org.jivesoftware.smackx.packet.JingleTransport;

public class JingleContent
implements PacketExtension {
    public static final String NODENAME = "content";
    public static final String CREATOR = "creator";
    public static final String NAME = "name";
    private String creator;
    private String name;
    private JingleDescription description;
    private final List<JingleTransport> transports = new ArrayList<JingleTransport>();

    public JingleContent(String string, String string2) {
        this.creator = string;
        this.name = string2;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getElementName() {
        return NODENAME;
    }

    @Override
    public String getNamespace() {
        return "";
    }

    public void setDescription(JingleDescription jingleDescription) {
        this.description = jingleDescription;
    }

    public JingleDescription getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJingleTransport(JingleTransport jingleTransport) {
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            this.transports.add(jingleTransport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransports(List<JingleTransport> list) {
        List<JingleTransport> list2 = list;
        synchronized (list2) {
            for (JingleTransport jingleTransport : list) {
                this.addJingleTransport(jingleTransport);
            }
        }
    }

    public Iterator<JingleTransport> getJingleTransports() {
        return Collections.unmodifiableList(this.getJingleTransportsList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleTransport> getJingleTransportsList() {
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            return new ArrayList<JingleTransport>(this.transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJingleTransportsCount() {
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            return this.transports.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            stringBuilder.append("<").append(this.getElementName());
            stringBuilder.append(" creator='" + this.creator + "' name='" + this.name + "'>");
            if (this.description != null) {
                stringBuilder.append(this.description.toXML());
            }
            for (JingleTransport jingleTransport : this.transports) {
                stringBuilder.append(jingleTransport.toXML());
            }
            stringBuilder.append("</").append(this.getElementName()).append(">");
        }
        return stringBuilder.toString();
    }
}

