/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.ResultListener;
import org.jivesoftware.smackx.jingle.nat.TestResult;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

public class ICECandidate
extends TransportCandidate
implements Comparable {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(ICECandidate.class);
    private String id;
    private String username;
    private int preference;
    private TransportCandidate.Protocol proto;
    private TransportCandidate.Channel channel;
    private int network;
    private Type type;

    public ICECandidate() {
    }

    public ICECandidate(String string, int n, int n2, String string2, int n3, String string3, int n4, Type type) {
        super(string, n3, n);
        this.proto = TransportCandidate.Protocol.UDP;
        this.channel = TransportCandidate.Channel.MYRTPVOICE;
        this.network = n2;
        this.password = string2;
        this.username = string3;
        this.preference = n4;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public TransportCandidate.Protocol getProto() {
        return this.proto;
    }

    public void setProto(TransportCandidate.Protocol protocol) {
        this.proto = protocol;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int n) {
        this.network = n;
    }

    public String getUsername() {
        return this.username;
    }

    public TransportCandidate.Channel getChannel() {
        return this.channel;
    }

    public void setChannel(TransportCandidate.Channel channel) {
        this.channel = channel;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public int getPreference() {
        return this.preference;
    }

    public void setPreference(int n) {
        this.preference = n;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void check(final List<TransportCandidate> list) {
        final ICECandidate iCECandidate = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                TransportCandidate.CandidateEcho candidateEcho;
                final TestResult testResult = new TestResult();
                if (ICECandidate.this.getType().equals("relay")) {
                    ICECandidate.this.triggerCandidateChecked(false);
                    return;
                }
                ResultListener resultListener = new ResultListener(){

                    @Override
                    public void testFinished(TestResult testResult2, TransportCandidate transportCandidate) {
                        if (testResult2.isReachable() && iCECandidate.equals(transportCandidate)) {
                            testResult.setResult(true);
                            LOGGER.debug("Candidate reachable: " + transportCandidate.getIp() + ":" + transportCandidate.getPort() + " from " + ICECandidate.this.getIp() + ":" + ICECandidate.this.getPort());
                        }
                    }
                };
                for (TransportCandidate transportCandidate : list) {
                    ICECandidate iCECandidate2;
                    candidateEcho = transportCandidate.getCandidateEcho();
                    if (candidateEcho == null || !(transportCandidate instanceof ICECandidate) || !(iCECandidate2 = (ICECandidate)transportCandidate).getType().equals((Object)ICECandidate.this.getType())) continue;
                    try {
                        candidateEcho.addResultListener(resultListener);
                        InetAddress inetAddress = InetAddress.getByName(ICECandidate.this.getIp());
                        candidateEcho.testASync(iCECandidate, ICECandidate.this.getPassword());
                    }
                    catch (UnknownHostException unknownHostException) {
                        unknownHostException.printStackTrace();
                    }
                }
                for (int i = 0; i < 10 && !testResult.isReachable(); ++i) {
                    try {
                        LOGGER.error("ICE Candidate retry #" + i);
                        Thread.sleep(400L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                for (TransportCandidate transportCandidate : list) {
                    candidateEcho = transportCandidate.getCandidateEcho();
                    if (candidateEcho == null) continue;
                    candidateEcho.removeResultListener(resultListener);
                }
                ICECandidate.this.triggerCandidateChecked(testResult.isReachable());
            }
        }, "Transport candidate check");
        thread.setName("Transport candidate test");
        thread.start();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ICECandidate iCECandidate = (ICECandidate)object;
        if (this.getChannel() == null ? iCECandidate.getChannel() != null : !this.getChannel().equals(iCECandidate.getChannel())) {
            return false;
        }
        if (this.getId() == null ? iCECandidate.getId() != null : !this.getId().equals(iCECandidate.getId())) {
            return false;
        }
        if (this.getNetwork() != iCECandidate.getNetwork()) {
            return false;
        }
        if (this.getPassword() == null ? iCECandidate.getPassword() != null : !this.getPassword().equals(iCECandidate.password)) {
            return false;
        }
        if (this.getPreference() != iCECandidate.getPreference()) {
            return false;
        }
        if (this.getProto() == null ? iCECandidate.getProto() != null : !this.getProto().equals(iCECandidate.getProto())) {
            return false;
        }
        if (this.getUsername() == null ? iCECandidate.getUsername() != null : !this.getUsername().equals(iCECandidate.getUsername())) {
            return false;
        }
        if (this.getIp() == null ? iCECandidate.getIp() != null : !this.getIp().equals(iCECandidate.getIp())) {
            return false;
        }
        if (this.getPort() != iCECandidate.getPort()) {
            return false;
        }
        return !(this.getType() == null ? iCECandidate.getType() != null : !this.getType().equals((Object)iCECandidate.getType()));
    }

    @Override
    public boolean isNull() {
        if (super.isNull()) {
            return true;
        }
        if (this.getProto().isNull()) {
            return true;
        }
        return this.getChannel().isNull();
    }

    public int compareTo(Object object) {
        if (object instanceof ICECandidate) {
            ICECandidate iCECandidate = (ICECandidate)object;
            if (this.getPreference() < iCECandidate.getPreference()) {
                return -1;
            }
            if (this.getPreference() > iCECandidate.getPreference()) {
                return 1;
            }
        }
        return 0;
    }

    public static enum Type {
        relay,
        srflx,
        prflx,
        local,
        host;

    }
}

