/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.listeners.CreatedJingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.ICEResolver;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.RTPBridge;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;

public class ICETransportManager
extends JingleTransportManager
implements JingleSessionListener,
CreatedJingleSessionListener {
    ICEResolver iceResolver = null;

    public ICETransportManager(Connection connection, String string, int n) {
        this.iceResolver = new ICEResolver(connection, string, n);
        try {
            this.iceResolver.initializeAndWait();
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
    }

    @Override
    protected TransportResolver createResolver(JingleSession jingleSession) {
        try {
            this.iceResolver.resolve(jingleSession);
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return this.iceResolver;
    }

    @Override
    public void sessionEstablished(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2, JingleSession jingleSession) {
        if (transportCandidate2 instanceof ICECandidate && ((ICECandidate)transportCandidate2).getType().equals("relay")) {
            RTPBridge rTPBridge = RTPBridge.relaySession(transportCandidate2.getConnection(), transportCandidate2.getSessionId(), transportCandidate2.getPassword(), transportCandidate, transportCandidate2);
        }
    }

    @Override
    public void sessionDeclined(String string, JingleSession jingleSession) {
    }

    @Override
    public void sessionRedirected(String string, JingleSession jingleSession) {
    }

    @Override
    public void sessionClosed(String string, JingleSession jingleSession) {
    }

    @Override
    public void sessionClosedOnError(XMPPException xMPPException, JingleSession jingleSession) {
    }

    @Override
    public void sessionMediaReceived(JingleSession jingleSession, String string) {
    }

    @Override
    public void sessionCreated(JingleSession jingleSession) {
        jingleSession.addListener(this);
    }
}

