/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionState;
import org.jivesoftware.smackx.jingle.JingleSessionStateActive;
import org.jivesoftware.smackx.packet.Jingle;

public class JingleSessionStatePending
extends JingleSessionState {
    private static JingleSessionStatePending INSTANCE = null;

    protected JingleSessionStatePending() {
    }

    public static synchronized JingleSessionState getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JingleSessionStatePending();
        }
        return INSTANCE;
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @Override
    public IQ processJingle(JingleSession jingleSession, Jingle jingle, JingleActionEnum jingleActionEnum) {
        IQ iQ = null;
        switch (jingleActionEnum) {
            case CONTENT_ACCEPT: {
                iQ = this.receiveContentAcceptAction(jingle);
                break;
            }
            case CONTENT_MODIFY: {
                break;
            }
            case CONTENT_REMOVE: {
                break;
            }
            case SESSION_ACCEPT: {
                iQ = this.receiveSessionAcceptAction(jingleSession, jingle);
                break;
            }
            case SESSION_INFO: {
                break;
            }
            case SESSION_TERMINATE: {
                iQ = this.receiveSessionTerminateAction(jingleSession, jingle);
                break;
            }
            case TRANSPORT_INFO: {
                break;
            }
        }
        return iQ;
    }

    private IQ receiveContentAcceptAction(Jingle jingle) {
        return null;
    }

    private IQ receiveSessionAcceptAction(JingleSession jingleSession, Jingle jingle) {
        jingleSession.setSessionState(JingleSessionStateActive.getInstance());
        return jingleSession.createAck(jingle);
    }

    private IQ receiveSessionTerminateAction(JingleSession jingleSession, Jingle jingle) {
        IQ iQ = jingleSession.createAck(jingle);
        try {
            jingleSession.terminate("Closed remotely");
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return iQ;
    }
}

