/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionState;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleError;

public class JingleSessionStateActive
extends JingleSessionState {
    private static JingleSessionStateActive INSTANCE = null;

    protected JingleSessionStateActive() {
    }

    public static synchronized JingleSessionState getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JingleSessionStateActive();
        }
        return INSTANCE;
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @Override
    public IQ processJingle(JingleSession jingleSession, Jingle jingle, JingleActionEnum jingleActionEnum) {
        IQ iQ = null;
        switch (jingleActionEnum) {
            case CONTENT_ACCEPT: {
                break;
            }
            case CONTENT_ADD: {
                break;
            }
            case CONTENT_MODIFY: {
                break;
            }
            case CONTENT_REMOVE: {
                break;
            }
            case SESSION_INFO: {
                break;
            }
            case SESSION_TERMINATE: {
                this.receiveSessionTerminateAction(jingleSession, jingle);
                break;
            }
            case TRANSPORT_INFO: {
                break;
            }
            default: {
                iQ = jingleSession.createJingleError(jingle, JingleError.OUT_OF_ORDER);
            }
        }
        return iQ;
    }

    private IQ receiveSessionTerminateAction(JingleSession jingleSession, Jingle jingle) {
        IQ iQ = jingleSession.createAck(jingle);
        try {
            jingleSession.terminate("Closed remotely");
        }
        catch (XMPPException xMPPException) {
            xMPPException.printStackTrace();
        }
        return iQ;
    }
}

