/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.MediaNegotiator;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportNegotiator;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContent;

public class ContentNegotiator
extends JingleNegotiator {
    public static final String INITIATOR = "initiator";
    public static final String RESPONDER = "responder";
    private List<TransportNegotiator> transportNegotiators;
    private MediaNegotiator mediaNeg;
    private TransportNegotiator transNeg;
    private JingleTransportManager jingleTransportManager;
    private String creator;
    private String name;
    private JingleMediaSession jingleMediaSession = null;

    public ContentNegotiator(JingleSession jingleSession, String string, String string2) {
        super(jingleSession);
        this.creator = string;
        this.name = string2;
        this.transportNegotiators = new ArrayList<TransportNegotiator>();
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iQ, String string) throws XMPPException {
        ArrayList<IQ> arrayList = new ArrayList<IQ>();
        if (iQ != null && !iQ.getType().equals(IQ.Type.ERROR)) {
            if (iQ.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iQ.getPacketID())) {
                    this.removeExpectedId(iQ.getPacketID());
                }
            } else if (iQ instanceof Jingle) {
                Jingle jingle = (Jingle)iQ;
                for (JingleContent jingleContent : jingle.getContentsList()) {
                    if (!jingleContent.getName().equals(this.name)) continue;
                    if (this.mediaNeg != null) {
                        arrayList.addAll(this.mediaNeg.dispatchIncomingPacket(iQ, string));
                    }
                    if (this.transNeg == null) continue;
                    arrayList.addAll(this.transNeg.dispatchIncomingPacket(iQ, string));
                }
            }
        }
        return arrayList;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    public JingleMediaSession getJingleMediaSession() {
        return this.jingleMediaSession;
    }

    public void addTransportNegotiator(TransportNegotiator transportNegotiator) {
        this.transportNegotiators.add(transportNegotiator);
    }

    public void setJingleTransportManager(JingleTransportManager jingleTransportManager) {
        this.jingleTransportManager = jingleTransportManager;
    }

    public JingleTransportManager getTransportManager() {
        return this.jingleTransportManager;
    }

    @Override
    protected void doStart() {
        JingleContent jingleContent = new JingleContent(this.creator, this.name);
        this.mediaNeg.start();
        this.transNeg.start();
    }

    @Override
    public void close() {
        this.destroyMediaNegotiator();
        this.destroyTransportNegotiator();
    }

    public MediaNegotiator getMediaNegotiator() {
        return this.mediaNeg;
    }

    protected void setMediaNegotiator(MediaNegotiator mediaNegotiator) {
        this.destroyMediaNegotiator();
        this.mediaNeg = mediaNegotiator;
    }

    protected void destroyMediaNegotiator() {
        if (this.mediaNeg != null) {
            this.mediaNeg.close();
            this.mediaNeg = null;
        }
    }

    public TransportNegotiator getTransportNegotiator() {
        return this.transNeg;
    }

    protected void setTransportNegotiator(TransportNegotiator transportNegotiator) {
        this.destroyTransportNegotiator();
        this.transNeg = transportNegotiator;
    }

    protected void destroyTransportNegotiator() {
        if (this.transNeg != null) {
            this.transNeg.close();
            this.transNeg = null;
        }
    }

    public boolean isFullyEstablished() {
        TransportNegotiator transportNegotiator;
        boolean bl = true;
        MediaNegotiator mediaNegotiator = this.getMediaNegotiator();
        if (mediaNegotiator == null || !mediaNegotiator.isFullyEstablished()) {
            bl = false;
        }
        if ((transportNegotiator = this.getTransportNegotiator()) == null || !transportNegotiator.isFullyEstablished()) {
            bl = false;
        }
        return bl;
    }

    public JingleContent getJingleContent() {
        JingleContent jingleContent = new JingleContent(this.creator, this.name);
        if (this.mediaNeg != null) {
            jingleContent.setDescription(this.mediaNeg.getJingleDescription());
        }
        if (this.transNeg != null) {
            jingleContent.addJingleTransport(this.transNeg.getJingleTransport());
        }
        return jingleContent;
    }

    public void triggerContentEstablished() {
        PayloadType payloadType = this.getMediaNegotiator().getBestCommonAudioPt();
        TransportCandidate transportCandidate = this.getTransportNegotiator().getBestRemoteCandidate();
        TransportCandidate transportCandidate2 = this.getTransportNegotiator().getAcceptedLocalCandidate();
        this.triggerContentEstablished(payloadType, transportCandidate, transportCandidate2);
    }

    private void triggerContentEstablished(PayloadType payloadType, TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
        Iterator<TransportCandidate> iterator;
        JingleSession jingleSession = this.getSession();
        if (jingleSession != null) {
            iterator = jingleSession.getListenersList();
            Iterator<JingleListener> object = iterator.iterator();
            while (object.hasNext()) {
                JingleListener jingleListener = object.next();
                if (!(jingleListener instanceof JingleSessionListener)) continue;
                JingleSessionListener jingleSessionListener = (JingleSessionListener)jingleListener;
                jingleSessionListener.sessionEstablished(payloadType, transportCandidate, transportCandidate2, jingleSession);
            }
        }
        if (this.mediaNeg.getMediaManager() != null) {
            transportCandidate.removeCandidateEcho();
            transportCandidate2.removeCandidateEcho();
            this.jingleMediaSession = this.getMediaNegotiator().getMediaManager().createMediaSession(payloadType, transportCandidate, transportCandidate2, jingleSession);
            this.jingleMediaSession.addMediaReceivedListener(jingleSession);
            if (this.jingleMediaSession != null) {
                this.jingleMediaSession.startTrasmit();
                this.jingleMediaSession.startReceive();
                for (TransportCandidate transportCandidate3 : this.getTransportNegotiator().getOfferedCandidates()) {
                    transportCandidate3.removeCandidateEcho();
                }
            }
            iterator = this.getMediaNegotiator().getMediaManager();
            this.getSession().addJingleMediaSession(((JingleMediaManager)((Object)iterator)).getName(), this.jingleMediaSession);
        }
    }

    public void stopJingleMediaSession() {
        if (this.jingleMediaSession != null) {
            this.jingleMediaSession.stopTrasmit();
            this.jingleMediaSession.stopReceive();
        }
    }

    @Override
    public JingleNegotiatorState getNegotiatorState() {
        JingleNegotiatorState jingleNegotiatorState = JingleNegotiatorState.PENDING;
        if (this.mediaNeg != null && this.transNeg != null) {
            if (this.mediaNeg.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED || this.transNeg.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED) {
                jingleNegotiatorState = JingleNegotiatorState.SUCCEEDED;
            }
            if (this.mediaNeg.getNegotiatorState() == JingleNegotiatorState.FAILED || this.transNeg.getNegotiatorState() == JingleNegotiatorState.FAILED) {
                jingleNegotiatorState = JingleNegotiatorState.FAILED;
            }
        }
        this.setNegotiatorState(jingleNegotiatorState);
        return jingleNegotiatorState;
    }
}

