/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.smack.ConnectionConfiguration;

class ServerTrustManager
implements X509TrustManager {
    private static Pattern cnPattern = Pattern.compile("(?i)(cn=)([^,]*)");
    private ConnectionConfiguration configuration;
    private String server;
    private KeyStore trustStore;
    private static Map<KeyStoreOptions, KeyStore> stores = new HashMap<KeyStoreOptions, KeyStore>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTrustManager(String string, ConnectionConfiguration connectionConfiguration) {
        this.configuration = connectionConfiguration;
        this.server = string;
        InputStream inputStream = null;
        Map<KeyStoreOptions, KeyStore> map = stores;
        synchronized (map) {
            KeyStoreOptions keyStoreOptions = new KeyStoreOptions(connectionConfiguration.getTruststoreType(), connectionConfiguration.getTruststorePath(), connectionConfiguration.getTruststorePassword());
            if (stores.containsKey(keyStoreOptions)) {
                this.trustStore = stores.get(keyStoreOptions);
            } else {
                try {
                    this.trustStore = KeyStore.getInstance(keyStoreOptions.getType());
                    if (keyStoreOptions.getPath() != null) {
                        inputStream = new BufferedInputStream(new FileInputStream(keyStoreOptions.getPath()));
                    }
                    char[] cArray = null;
                    if (keyStoreOptions.getPassword() != null) {
                        cArray = keyStoreOptions.getPassword().toCharArray();
                    }
                    this.trustStore.load(inputStream, cArray);
                }
                catch (Exception exception) {
                    this.trustStore = null;
                    exception.printStackTrace();
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                stores.put(keyStoreOptions, this.trustStore);
            }
            if (this.trustStore == null) {
                connectionConfiguration.setVerifyRootCAEnabled(false);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        int n;
        Object object;
        int n2 = x509CertificateArray.length;
        List<String> list = ServerTrustManager.getPeerIdentity(x509CertificateArray[0]);
        if (this.configuration.isVerifyChainEnabled()) {
            object = null;
            for (n = n2 - 1; n >= 0; --n) {
                X509Certificate x509Certificate = x509CertificateArray[n];
                Principal principal = x509Certificate.getIssuerDN();
                Principal principal2 = x509Certificate.getSubjectDN();
                if (object != null) {
                    if (((Object)principal).equals(object)) {
                        try {
                            PublicKey publicKey = x509CertificateArray[n + 1].getPublicKey();
                            x509CertificateArray[n].verify(publicKey);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CertificateException("signature verification failed of " + list);
                        }
                    } else {
                        throw new CertificateException("subject/issuer verification failed of " + list);
                    }
                }
                object = principal2;
            }
        }
        if (this.configuration.isVerifyRootCAEnabled()) {
            boolean bl = false;
            try {
                boolean bl2 = bl = this.trustStore.getCertificateAlias(x509CertificateArray[n2 - 1]) != null;
                if (!bl && n2 == 1 && this.configuration.isSelfSignedCertificateEnabled()) {
                    System.out.println("Accepting self-signed certificate of remote server: " + list);
                    bl = true;
                }
            }
            catch (KeyStoreException keyStoreException) {
                keyStoreException.printStackTrace();
            }
            if (!bl) {
                throw new CertificateException("root certificate not trusted of " + list);
            }
        }
        if (this.configuration.isNotMatchingDomainCheckEnabled() && (list.size() == 1 && list.get(0).startsWith("*.") ? !this.server.endsWith((String)(object = list.get(0).replace("*.", ""))) : !list.contains(this.server))) {
            throw new CertificateException("target verification failed of " + list);
        }
        if (this.configuration.isExpiredCertificatesCheckEnabled()) {
            object = new Date();
            for (n = 0; n < n2; ++n) {
                try {
                    x509CertificateArray[n].checkValidity((Date)object);
                    continue;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new CertificateException("invalid date of " + this.server);
                }
            }
        }
    }

    public static List<String> getPeerIdentity(X509Certificate x509Certificate) {
        List<String> list = ServerTrustManager.getSubjectAlternativeNames(x509Certificate);
        if (list.isEmpty()) {
            String string = x509Certificate.getSubjectDN().getName();
            Matcher matcher = cnPattern.matcher(string);
            if (matcher.find()) {
                string = matcher.group(2);
            }
            list = new ArrayList<String>();
            list.add(string);
        }
        return list;
    }

    private static List<String> getSubjectAlternativeNames(X509Certificate x509Certificate) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return Collections.emptyList();
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            certificateParsingException.printStackTrace();
        }
        return arrayList;
    }

    private static class KeyStoreOptions {
        private final String type;
        private final String path;
        private final String password;

        public KeyStoreOptions(String string, String string2, String string3) {
            this.type = string;
            this.path = string2;
            this.password = string3;
        }

        public String getType() {
            return this.type;
        }

        public String getPath() {
            return this.path;
        }

        public String getPassword() {
            return this.password;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.password == null ? 0 : this.password.hashCode());
            n = 31 * n + (this.path == null ? 0 : this.path.hashCode());
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            KeyStoreOptions keyStoreOptions = (KeyStoreOptions)object;
            if (this.password == null ? keyStoreOptions.password != null : !this.password.equals(keyStoreOptions.password)) {
                return false;
            }
            if (this.path == null ? keyStoreOptions.path != null : !this.path.equals(keyStoreOptions.path)) {
                return false;
            }
            return !(this.type == null ? keyStoreOptions.type != null : !this.type.equals(keyStoreOptions.type));
        }
    }
}

