/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    private Connection connection;
    private Socks5BytestreamManager manager;

    Socks5TransferNegotiator(Connection connection) {
        this.connection = connection;
        this.manager = Socks5BytestreamManager.getBytestreamManager(this.connection);
    }

    @Override
    public OutputStream createOutgoingStream(String string, String string2, String string3) throws XMPPException {
        try {
            return this.manager.establishSession(string3, string).getOutputStream();
        }
        catch (IOException iOException) {
            throw new XMPPException("error establishing SOCKS5 Bytestream", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new XMPPException("error establishing SOCKS5 Bytestream", interruptedException);
        }
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation streamInitiation) throws XMPPException, InterruptedException {
        this.manager.ignoreBytestreamRequestOnce(streamInitiation.getSessionID());
        Packet packet = this.initiateIncomingStream(this.connection, streamInitiation);
        return this.negotiateIncomingStream(packet);
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String string, String string2) {
        this.manager.ignoreBytestreamRequestOnce(string2);
        return new AndFilter(new FromMatchesFilter(string), new BytestreamSIDFilter(string2));
    }

    @Override
    public String[] getNamespaces() {
        return new String[]{"http://jabber.org/protocol/bytestreams"};
    }

    @Override
    InputStream negotiateIncomingStream(Packet packet) throws XMPPException, InterruptedException {
        ByteStreamRequest byteStreamRequest = new ByteStreamRequest(this.manager, (Bytestream)packet);
        Socks5BytestreamSession socks5BytestreamSession = byteStreamRequest.accept();
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(socks5BytestreamSession.getInputStream());
            int n = pushbackInputStream.read();
            pushbackInputStream.unread(n);
            return pushbackInputStream;
        }
        catch (IOException iOException) {
            throw new XMPPException("Error establishing input stream", iOException);
        }
    }

    @Override
    public void cleanup() {
    }

    private static class ByteStreamRequest
    extends Socks5BytestreamRequest {
        private ByteStreamRequest(Socks5BytestreamManager socks5BytestreamManager, Bytestream bytestream) {
            super(socks5BytestreamManager, bytestream);
        }
    }

    private static class BytestreamSIDFilter
    extends PacketTypeFilter {
        private String sessionID;

        public BytestreamSIDFilter(String string) {
            super(Bytestream.class);
            if (string == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = string;
        }

        @Override
        public boolean accept(Packet packet) {
            if (super.accept(packet)) {
                Bytestream bytestream = (Bytestream)packet;
                return this.sessionID.equals(bytestream.getSessionID()) && IQ.Type.SET.equals(bytestream.getType());
            }
            return false;
        }
    }
}

