package com.beem.project.beem;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.RemoteException;
import android.widget.Toast;

import com.beem.project.beem.service.XMPPConnectionAdapter;
import com.beem.project.beem.service.XMPPFacade;
import com.beem.project.beem.service.aidl.IXMPPFacade;
import com.beem.project.beem.service.aidl.IXmppConnection;
/**
 * This class is for the Beem service.
 * @author darisk
 *
 */
public class BeemService extends Service {

    private NotificationManager mNotificationManager;

    private IXmppConnection mConnection;
    private SharedPreferences mSettings;
    private String mLogin;
    private String mPassword;
    private String mHost;

    private IXMPPFacade.Stub mBind;

    /**
     * {@inheritDoc}
     */
    @Override
    public IBinder onBind(Intent intent) {
	showBasicNotification(R.string.BeemServiceCreated);
	return mBind;
	// to forbid a client to bind
	// return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onCreate() {
	super.onCreate();
	mSettings = getSharedPreferences(getString(R.string.PreferenceFileName),
		MODE_PRIVATE);
	mLogin = mSettings.getString(getString(R.string.PreferenceLoginKey), "");
	mPassword = mSettings.getString(
		getString(R.string.PreferencePasswordKey), "");
	mHost = mSettings.getString(getString(R.string.PreferenceHostKey), "");
	mNotificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
	mConnection = new XMPPConnectionAdapter("10.0.2.2", mLogin, mPassword); // address
	mBind = new XMPPFacade((XMPPConnectionAdapter) mConnection);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onStart(Intent intent, int startId) {
	try {
	    mConnection.connectSync();
	} catch (RemoteException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void onDestroy() {
	closeConnection();
	showBasicNotification(R.string.BeemServiceDestroyed);
    }

    /**
     * Close the connection to the xmpp server.
     */
    private void closeConnection() {
	if (mConnection != null)
	    try {
		mConnection.disconnect();
	    } catch (RemoteException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
    }

    /**
     * Add a notification in the notification status bar.
     * @param stringResource	the ressource of the text to show
     */
    private void showBasicNotification(int stringResource) {
        String text = (String) getText(stringResource);
        Notification notif = new Notification(R.drawable.logo, text, System
                .currentTimeMillis());
        notif.defaults = Notification.DEFAULT_ALL;
        notif.setLatestEventInfo(this, text, text, PendingIntent.getActivity(
                this, 0, new Intent(), 0));
        mNotificationManager.notify(stringResource, notif);
        Toast toast = Toast.makeText(this, R.string.BeemServiceCreated,
                Toast.LENGTH_LONG);
        toast.show();
    }


}
