/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.Header;
import org.jivesoftware.smackx.packet.HeadersExtension;
import org.jivesoftware.smackx.pubsub.ConfigurationEvent;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.ItemDeleteEvent;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.OptionsExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.RetractItem;
import org.jivesoftware.smackx.pubsub.SubscribeExtension;
import org.jivesoftware.smackx.pubsub.SubscribeForm;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.UnsubscribeExtension;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.listener.NodeConfigListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.packet.SyncPacketSend;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    protected Connection con;
    protected String id;
    protected String to;
    protected ConcurrentHashMap<ItemEventListener, PacketListener> itemEventToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<ItemDeleteListener, PacketListener> itemDeleteToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<NodeConfigListener, PacketListener> configEventToListenerMap = new ConcurrentHashMap();

    Node(Connection connection, String string) {
        this.con = connection;
        this.id = string;
    }

    public void setTo(String string) {
        this.to = string;
    }

    public String getId() {
        return this.id;
    }

    public ConfigureForm getNodeConfiguration() throws XMPPException {
        Packet packet = this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.CONFIGURE_OWNER, this.getId()), PubSubNamespace.OWNER);
        return NodeUtils.getFormFromPacket(packet, PubSubElementType.CONFIGURE_OWNER);
    }

    public void sendConfigurationForm(Form form) throws XMPPException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new FormNode(FormNodeType.CONFIGURE_OWNER, this.getId(), form), PubSubNamespace.OWNER);
        SyncPacketSend.getReply(this.con, pubSub);
    }

    public DiscoverInfo discoverInfo() throws XMPPException {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setTo(this.to);
        discoverInfo.setNode(this.getId());
        return (DiscoverInfo)SyncPacketSend.getReply(this.con, discoverInfo);
    }

    public List<Subscription> getSubscriptions() throws XMPPException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new NodeExtension(PubSubElementType.SUBSCRIPTIONS, this.getId()));
        SubscriptionsExtension subscriptionsExtension = (SubscriptionsExtension)pubSub.getExtension(PubSubElementType.SUBSCRIPTIONS);
        return subscriptionsExtension.getSubscriptions();
    }

    public Subscription subscribe(String string) throws XMPPException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.SET, new SubscribeExtension(string, this.getId()));
        return (Subscription)pubSub.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    public Subscription subscribe(String string, SubscribeForm subscribeForm) throws XMPPException {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.SET, new SubscribeExtension(string, this.getId()));
        pubSub.addExtension(new FormNode(FormNodeType.OPTIONS, subscribeForm));
        PubSub pubSub2 = (PubSub)PubSubManager.sendPubsubPacket(this.con, string, IQ.Type.SET, pubSub);
        return (Subscription)pubSub2.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    public void unsubscribe(String string) throws XMPPException {
        this.unsubscribe(string, null);
    }

    public void unsubscribe(String string, String string2) throws XMPPException {
        this.sendPubsubPacket(IQ.Type.SET, new UnsubscribeExtension(string, this.getId(), string2));
    }

    public SubscribeForm getSubscriptionOptions(String string) throws XMPPException {
        return this.getSubscriptionOptions(string, null);
    }

    public SubscribeForm getSubscriptionOptions(String string, String string2) throws XMPPException {
        PubSub pubSub = (PubSub)this.sendPubsubPacket(IQ.Type.GET, new OptionsExtension(string, this.getId(), string2));
        FormNode formNode = (FormNode)pubSub.getExtension(PubSubElementType.OPTIONS);
        return new SubscribeForm(formNode.getForm());
    }

    public void addItemEventListener(ItemEventListener itemEventListener) {
        ItemEventTranslator itemEventTranslator = new ItemEventTranslator(itemEventListener);
        this.itemEventToListenerMap.put(itemEventListener, itemEventTranslator);
        this.con.addPacketListener(itemEventTranslator, new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeItemEventListener(ItemEventListener itemEventListener) {
        PacketListener packetListener = this.itemEventToListenerMap.remove(itemEventListener);
        if (packetListener != null) {
            this.con.removePacketListener(packetListener);
        }
    }

    public void addConfigurationListener(NodeConfigListener nodeConfigListener) {
        NodeConfigTranslator nodeConfigTranslator = new NodeConfigTranslator(nodeConfigListener);
        this.configEventToListenerMap.put(nodeConfigListener, nodeConfigTranslator);
        this.con.addPacketListener(nodeConfigTranslator, new EventContentFilter(EventElementType.configuration.toString()));
    }

    public void removeConfigurationListener(NodeConfigListener nodeConfigListener) {
        PacketListener packetListener = this.configEventToListenerMap.remove(nodeConfigListener);
        if (packetListener != null) {
            this.con.removePacketListener(packetListener);
        }
    }

    public void addItemDeleteListener(ItemDeleteListener itemDeleteListener) {
        ItemDeleteTranslator itemDeleteTranslator = new ItemDeleteTranslator(itemDeleteListener);
        this.itemDeleteToListenerMap.put(itemDeleteListener, itemDeleteTranslator);
        EventContentFilter eventContentFilter = new EventContentFilter(EventElementType.items.toString(), "retract");
        EventContentFilter eventContentFilter2 = new EventContentFilter(EventElementType.purge.toString());
        this.con.addPacketListener(itemDeleteTranslator, new OrFilter(eventContentFilter, eventContentFilter2));
    }

    public void removeItemDeleteListener(ItemDeleteListener itemDeleteListener) {
        PacketListener packetListener = this.itemDeleteToListenerMap.remove(itemDeleteListener);
        if (packetListener != null) {
            this.con.removePacketListener(packetListener);
        }
    }

    public String toString() {
        return super.toString() + " " + this.getClass().getName() + " id: " + this.id;
    }

    protected PubSub createPubsubPacket(IQ.Type type, PacketExtension packetExtension) {
        return this.createPubsubPacket(type, packetExtension, null);
    }

    protected PubSub createPubsubPacket(IQ.Type type, PacketExtension packetExtension, PubSubNamespace pubSubNamespace) {
        return PubSubManager.createPubsubPacket(this.to, type, packetExtension, pubSubNamespace);
    }

    protected Packet sendPubsubPacket(IQ.Type type, NodeExtension nodeExtension) throws XMPPException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, nodeExtension);
    }

    protected Packet sendPubsubPacket(IQ.Type type, NodeExtension nodeExtension, PubSubNamespace pubSubNamespace) throws XMPPException {
        return PubSubManager.sendPubsubPacket(this.con, this.to, type, nodeExtension, pubSubNamespace);
    }

    private static List<String> getSubscriptionIds(Packet packet) {
        HeadersExtension headersExtension = (HeadersExtension)packet.getExtension("headers", "http://jabber.org/protocol/shim");
        ArrayList<String> arrayList = null;
        if (headersExtension != null) {
            arrayList = new ArrayList<String>(headersExtension.getHeaders().size());
            for (Header header : headersExtension.getHeaders()) {
                arrayList.add(header.getValue());
            }
        }
        return arrayList;
    }

    class EventContentFilter
    implements PacketFilter {
        private String firstElement;
        private String secondElement;

        EventContentFilter(String string) {
            this.firstElement = string;
        }

        EventContentFilter(String string, String string2) {
            this.firstElement = string;
            this.secondElement = string2;
        }

        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            EventElement eventElement = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            if (eventElement == null) {
                return false;
            }
            NodeExtension nodeExtension = eventElement.getEvent();
            if (nodeExtension == null) {
                return false;
            }
            if (nodeExtension.getElementName().equals(this.firstElement)) {
                List<PacketExtension> list;
                if (!nodeExtension.getNode().equals(Node.this.getId())) {
                    return false;
                }
                if (this.secondElement == null) {
                    return true;
                }
                if (nodeExtension instanceof EmbeddedPacketExtension && (list = ((EmbeddedPacketExtension)((Object)nodeExtension)).getExtensions()).size() > 0 && list.get(0).getElementName().equals(this.secondElement)) {
                    return true;
                }
            }
            return false;
        }
    }

    public class NodeConfigTranslator
    implements PacketListener {
        private NodeConfigListener listener;

        public NodeConfigTranslator(NodeConfigListener nodeConfigListener) {
            this.listener = nodeConfigListener;
        }

        public void processPacket(Packet packet) {
            EventElement eventElement = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ConfigurationEvent configurationEvent = (ConfigurationEvent)eventElement.getEvent();
            this.listener.handleNodeConfiguration(configurationEvent);
        }
    }

    public class ItemDeleteTranslator
    implements PacketListener {
        private ItemDeleteListener listener;

        public ItemDeleteTranslator(ItemDeleteListener itemDeleteListener) {
            this.listener = itemDeleteListener;
        }

        public void processPacket(Packet packet) {
            EventElement eventElement = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            List<PacketExtension> list = eventElement.getExtensions();
            if (list.get(0).getElementName().equals(PubSubElementType.PURGE_EVENT.getElementName())) {
                this.listener.handlePurge();
            } else {
                Object object;
                ItemsExtension itemsExtension = (ItemsExtension)eventElement.getEvent();
                List<? extends PacketExtension> list2 = itemsExtension.getItems();
                Iterator iterator = list2.iterator();
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                while (iterator.hasNext()) {
                    object = (RetractItem)iterator.next();
                    arrayList.add(((RetractItem)object).getId());
                }
                object = new ItemDeleteEvent(itemsExtension.getNode(), arrayList, Node.getSubscriptionIds(packet));
                this.listener.handleDeletedItems((ItemDeleteEvent)object);
            }
        }
    }

    public class ItemEventTranslator
    implements PacketListener {
        private ItemEventListener listener;

        public ItemEventTranslator(ItemEventListener itemEventListener) {
            this.listener = itemEventListener;
        }

        public void processPacket(Packet packet) {
            EventElement eventElement = (EventElement)packet.getExtension("event", PubSubNamespace.EVENT.getXmlns());
            ItemsExtension itemsExtension = (ItemsExtension)eventElement.getEvent();
            DelayInformation delayInformation = (DelayInformation)packet.getExtension("delay", "urn:xmpp:delay");
            if (delayInformation == null) {
                delayInformation = (DelayInformation)packet.getExtension("x", "jabber:x:delay");
            }
            ItemPublishEvent<? extends PacketExtension> itemPublishEvent = new ItemPublishEvent<PacketExtension>(itemsExtension.getNode(), itemsExtension.getItems(), Node.getSubscriptionIds(packet), delayInformation == null ? null : delayInformation.getStamp());
            this.listener.handlePublishedItems(itemPublishEvent);
        }
    }
}

