/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.jingle;

import java.net.DatagramSocket;
import java.net.SocketException;

import jlibrtp.Participant;
import jlibrtp.RTPAppIntf;
import jlibrtp.RTPSession;

// TODO: Auto-generated Javadoc
/**
 * abstract RTP receiver class.
 * @author nikita
 */
public abstract class RTPReceiver implements Runnable, RTPAppIntf {

    private boolean mKillme;
    private RTPSession mRtpSession;

    /**
     * constructor.
     * @param rtpPort local or distant?.
     */
    public RTPReceiver(final int rtpPort) {
	DatagramSocket rtpSocket = null;

	try {
	    rtpSocket = new DatagramSocket(rtpPort);
	} catch (SocketException e) {
	    e.printStackTrace();
	    return;
	}
	mRtpSession = new RTPSession(rtpSocket, null);
	mRtpSession.naivePktReception(true);
	mRtpSession.RTPSessionRegister(this, null, null);
    }

    /* (non-Javadoc)
     * @see org.jlibrtp.jlibrtp.RTPAppIntf#frameSize(int)
     */
    @Override
    public int frameSize(int payloadType) {
	return 1;
    }

    /* (non-Javadoc)
     * @see java.lang.Runnable#run()
     */
    @Override
    public void run() {
	start();
	this.mRtpSession.endSession();
    }

    /**
     * main reception loop.
     */
    protected abstract void start();

    /**
     * Stop the reception.
     */
    public void stop() {
	this.setKillme(true);
    }

    /* (non-Javadoc)
     * @see org.jlibrtp.jlibrtp.RTPAppIntf#userEvent(int, org.jlibrtp.jlibrtp.Participant[])
     */
    @Override
    public void userEvent(int arg0, Participant[] arg1) {
	// TODO Auto-generated method stub
    }

    /**
     * mKillme setter.
     * @param killme the mKillme to set
     */
    public void setKillme(final boolean killme) {
	this.mKillme = killme;
    }

    /**
     * mKillme getter.
     * @return the mKillme
     */
    public boolean isKillme() {
	return mKillme;
    }
}
