package org.sipdroid.net.tools;

import jlibrtp.RtpPkt;

public class RtpPktPool extends ObjectPool {

	private static RtpPktPool instance = null;
	public static RtpPktPool getInstance() {
		if(instance == null) {
			instance = new RtpPktPool(20);
		}
		return instance;
	}
	
	public static void removeInstance() {
		instance = null;
	}
	
	protected RtpPktPool(int nbObject) {
		super(nbObject);
		for(int i = 0; i < nbObject; ++i) {
			checkIn(create());
		}
	}
	
	@Override
	Object create() {
		return new RtpPkt();
	}

	@Override
	boolean validate(Object o) {
		return true;
	}

	public RtpPkt borrowPkt() {
		return (RtpPkt) super.checkOut();
	}
	
	public void returnPkt(RtpPkt o) {
		super.checkIn(o);
	}
	
}
