/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import de.javawi.jstun.test.BindingLifetimeTest;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class STUNResolver
extends TransportResolver {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(STUNResolver.class);
    public static final String STUNSERVERS_FILENAME = "META-INF/stun-config.xml";
    private static final String FALLBACKHOSTNAME = "stun.xten.net";
    private static final int FALLBACKHOSTPORT = 3478;
    protected STUNService currentServer = new STUNService();
    protected Thread resolverThread;
    protected int defaultPort = 0;
    protected String resolvedPublicIP;
    protected String resolvedLocalIP;

    public STUNResolver() {
    }

    public STUNResolver(int n) {
        this();
        this.defaultPort = n;
    }

    public boolean isResolving() {
        return super.isResolving() && this.resolverThread != null;
    }

    public void setSTUNService(String string, int n) {
        this.currentServer = new STUNService(string, n);
    }

    public String getCurrentServerName() {
        if (!this.currentServer.isNull()) {
            return this.currentServer.getHostname();
        }
        return null;
    }

    public int getCurrentServerPort() {
        if (!this.currentServer.isNull()) {
            return this.currentServer.getPort();
        }
        return 0;
    }

    public ArrayList loadSTUNServers(InputStream inputStream) {
        ArrayList<STUNService> arrayList = new ArrayList<STUNService>();
        try {
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            xmlPullParser.setInput(inputStream, "UTF-8");
            int n = xmlPullParser.getEventType();
            do {
                if (n != 2 || !xmlPullParser.getName().equals("stunServer")) continue;
                String string = null;
                int n2 = -1;
                xmlPullParser.next();
                xmlPullParser.next();
                string = xmlPullParser.nextText();
                xmlPullParser.next();
                xmlPullParser.next();
                try {
                    n2 = Integer.parseInt(xmlPullParser.nextText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null || n2 == -1) continue;
                STUNService sTUNService = new STUNService(string, n2);
                arrayList.add(sTUNService);
            } while ((n = xmlPullParser.next()) != 1);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.currentServer = this.bestSTUNServer(arrayList);
        return arrayList;
    }

    public ArrayList loadSTUNServers() {
        ArrayList<STUNService> arrayList = new ArrayList<STUNService>();
        try {
            ClassLoader[] classLoaderArray = new ClassLoader[]{new STUNResolver(){}.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()};
            for (int i = 0; i < classLoaderArray.length; ++i) {
                Enumeration<URL> enumeration = classLoaderArray[i].getResources(STUNSERVERS_FILENAME);
                while (enumeration.hasMoreElements() && arrayList.isEmpty()) {
                    URL uRL = enumeration.nextElement();
                    InputStream inputStream = null;
                    inputStream = uRL.openStream();
                    arrayList.addAll(this.loadSTUNServers(inputStream));
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (arrayList.isEmpty()) {
            this.currentServer = new STUNService(FALLBACKHOSTNAME, 3478);
            arrayList.add(this.currentServer);
        }
        return arrayList;
    }

    private STUNService bestSTUNServer(ArrayList arrayList) {
        if (arrayList.isEmpty()) {
            return null;
        }
        return (STUNService)arrayList.get(0);
    }

    public synchronized void resolve(JingleSession jingleSession) throws XMPPException {
        this.setResolveInit();
        this.clearCandidates();
        TransportCandidate.Fixed fixed = new TransportCandidate.Fixed(this.resolvedPublicIP, this.getFreePort());
        fixed.setLocalIp(this.resolvedLocalIP);
        LOGGER.debug("RESOLVING : " + this.resolvedPublicIP + ":" + fixed.getPort());
        this.addCandidate(fixed);
        this.setResolveEnd();
    }

    public void initialize() throws XMPPException {
        LOGGER.debug("Initialized");
        if (!this.isResolving() && !this.isResolved()) {
            if (this.currentServer.isNull()) {
                this.loadSTUNServers();
            }
            if (!this.currentServer.isNull()) {
                this.clearCandidates();
                this.resolverThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                            while (enumeration.hasMoreElements()) {
                                NetworkInterface networkInterface = enumeration.nextElement();
                                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                                while (enumeration2.hasMoreElements()) {
                                    InetAddress inetAddress = enumeration2.nextElement();
                                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                                    String string = null;
                                    int n = -1;
                                    DiscoveryTest discoveryTest = new DiscoveryTest(inetAddress, STUNResolver.this.currentServer.getHostname(), STUNResolver.this.currentServer.getPort());
                                    try {
                                        DiscoveryInfo discoveryInfo = discoveryTest.test();
                                        string = discoveryInfo.getPublicIP() != null ? discoveryInfo.getPublicIP().getHostAddress() : null;
                                        n = STUNResolver.this.defaultPort == 0 ? STUNResolver.this.getFreePort() : STUNResolver.this.defaultPort;
                                        if (string == null || n < 0) continue;
                                        TransportCandidate.Fixed fixed = new TransportCandidate.Fixed(string, n);
                                        fixed.setLocalIp(inetAddress.getHostAddress() != null ? inetAddress.getHostAddress() : inetAddress.getHostName());
                                        STUNResolver.this.addCandidate(fixed);
                                        STUNResolver.this.resolvedPublicIP = fixed.getIp();
                                        STUNResolver.this.resolvedLocalIP = fixed.getLocalIp();
                                        return;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                        }
                        catch (SocketException socketException) {
                            socketException.printStackTrace();
                        }
                        finally {
                            STUNResolver.this.setInitialized();
                        }
                    }
                }, "Waiting for all the transport candidates checks...");
                this.resolverThread.setName("STUN resolver");
                this.resolverThread.start();
            } else {
                throw new IllegalStateException("No valid STUN server found.");
            }
        }
    }

    public synchronized void cancel() throws XMPPException {
        if (this.isResolving()) {
            this.resolverThread.interrupt();
            this.setResolveEnd();
        }
    }

    public synchronized void clear() throws XMPPException {
        this.defaultPort = 0;
        super.clear();
    }

    protected class STUNService {
        private String hostname;
        private int port;

        public STUNService(String string, int n) {
            this.hostname = string;
            this.port = n;
        }

        public STUNService() {
            this(null, -1);
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String string) {
            this.hostname = string;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int n) {
            this.port = n;
        }

        public boolean isNull() {
            if (this.hostname == null) {
                return true;
            }
            if (this.hostname.length() == 0) {
                return true;
            }
            return this.port < 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkBinding() {
            boolean bl = false;
            try {
                BindingLifetimeTest bindingLifetimeTest = new BindingLifetimeTest(this.hostname, this.port);
                bindingLifetimeTest.test();
                do {
                    Thread.sleep(5000L);
                    if (bindingLifetimeTest.getLifetime() == -1) return bl;
                } while (!bindingLifetimeTest.isCompleted());
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return bl;
        }
    }
}

