/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyParser;
import com.kenai.jbosh.BodyParserResults;
import com.kenai.jbosh.BodyParserXmlPull;
import com.kenai.jbosh.BodyQName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

final class StaticBody
extends AbstractBody {
    private static final BodyParser PARSER = new BodyParserXmlPull();
    private static final int BUFFER_SIZE = 1024;
    private final Map<BodyQName, String> attrs;
    private final String raw;

    private StaticBody(Map<BodyQName, String> map, String string) {
        this.attrs = map;
        this.raw = string;
    }

    public static StaticBody fromStream(InputStream inputStream) throws BOSHException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] byArray = new byte[1024];
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n >= 0);
        }
        catch (IOException iOException) {
            throw new BOSHException("Could not read body data", iOException);
        }
        return StaticBody.fromString(byteArrayOutputStream.toString());
    }

    public static StaticBody fromString(String string) throws BOSHException {
        BodyParserResults bodyParserResults = PARSER.parse(string);
        return new StaticBody(bodyParserResults.getAttributes(), string);
    }

    @Override
    public Map<BodyQName, String> getAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    @Override
    public String toXML() {
        return this.raw;
    }
}

