/*
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Veronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program "Beem"
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.jingle;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

import android.content.Context;

/**
 * RTPMediaManager, gere les payloads et renvoie une session RTP.
 * @author nikita
 */
public class MicrophoneRTPManager extends JingleMediaManager {
	/**
	 * RTP media name.
	 */
	public static final String MEDIA_NAME = "Microphone";

	private List<PayloadType> mPayloads;

	private Context mCtx;

	/**
	 * Manage Microphone data transmission trough RTP.
	 * @param transportManager current jingle transport manager(basic,upnp,ice...).
	 */
	public MicrophoneRTPManager(final JingleTransportManager transportManager, Context ctx) {
		super(transportManager);
		setupPayloads();
		mCtx = ctx;
	}

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaManager#createMediaSession(org.jivesoftware.smackx.jingle.media.PayloadType, org.jivesoftware.smackx.jingle.nat.TransportCandidate, org.jivesoftware.smackx.jingle.nat.TransportCandidate, org.jivesoftware.smackx.jingle.JingleSession)
     */
	@Override
	public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote,
			TransportCandidate local, JingleSession jingleSession) {
		return new RTPAudioSession(payloadType, remote, local, null, jingleSession, mCtx);
	}

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaManager#getName()
     */
	@Override
	public String getName() {
		return MEDIA_NAME;
	}

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaManager#getPayloads()
     */
	@Override
	public List<PayloadType> getPayloads() {
		return mPayloads;
	}

	/**
	 * Supported payload list.
	 */
	private void setupPayloads() {
		mPayloads = new ArrayList<PayloadType>();
		mPayloads.add(new PayloadType.Audio(8, "PCMA"));
		mPayloads.add(new PayloadType.Audio(9, "G722"));
		mPayloads.add(new PayloadType.Audio(3, "GSM"));
	}
}
