/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.ContentNegotiator;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleException;
import org.jivesoftware.smackx.jingle.JingleNegotiator;
import org.jivesoftware.smackx.jingle.JingleNegotiatorState;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.listeners.JingleListener;
import org.jivesoftware.smackx.jingle.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;
import org.jivesoftware.smackx.jingle.nat.TransportResolverListener;
import org.jivesoftware.smackx.packet.Jingle;
import org.jivesoftware.smackx.packet.JingleContent;
import org.jivesoftware.smackx.packet.JingleTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransportNegotiator
extends JingleNegotiator {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(TransportNegotiator.class);
    public static final int CANDIDATES_ACCEPT_PERIOD = 4000;
    private final TransportResolver resolver;
    private final List<TransportCandidate> offeredCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> remoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> validRemoteCandidates = new ArrayList<TransportCandidate>();
    private final List<TransportCandidate> acceptedRemoteCandidates = new ArrayList<TransportCandidate>();
    private TransportCandidate acceptedLocalCandidate;
    private Thread resultThread;
    private TransportResolverListener.Resolver resolverListener;
    private ContentNegotiator parentNegotiator;

    public TransportNegotiator(JingleSession session, TransportResolver transResolver, ContentNegotiator parentNegotiator) {
        super(session);
        this.resolver = transResolver;
        this.parentNegotiator = parentNegotiator;
        this.resultThread = null;
    }

    public abstract JingleTransport getJingleTransport(TransportCandidate var1);

    public abstract boolean acceptableTransportCandidate(TransportCandidate var1, List<TransportCandidate> var2);

    public final TransportCandidate getBestLocalCandidate() {
        return this.resolver.getPreferredCandidate();
    }

    private void setAcceptedLocalCandidate(TransportCandidate bestLocalCandidate) throws XMPPException {
        for (int i = 0; i < this.resolver.getCandidateCount(); ++i) {
            if (!this.resolver.getCandidate(i).getIp().equals(bestLocalCandidate.getIp()) || this.resolver.getCandidate(i).getPort() != bestLocalCandidate.getPort()) continue;
            this.acceptedLocalCandidate = this.resolver.getCandidate(i);
            return;
        }
        LOGGER.debug("BEST: ip=" + bestLocalCandidate.getIp() + " port=" + bestLocalCandidate.getPort() + " has not been offered.");
    }

    public TransportCandidate getAcceptedLocalCandidate() {
        return this.acceptedLocalCandidate;
    }

    @Override
    protected void doStart() {
        try {
            this.sendTransportCandidatesOffer();
            this.setNegotiatorState(JingleNegotiatorState.PENDING);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public JingleTransport getJingleTransport() {
        return this.getJingleTransport(this.getBestRemoteCandidate());
    }

    public List<TransportCandidate> getOfferedCandidates() {
        return this.offeredCandidates;
    }

    public abstract TransportCandidate getBestRemoteCandidate();

    private List<TransportCandidate> getRemoteCandidates() {
        return this.remoteCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteCandidate(TransportCandidate rc) {
        if (rc != null && this.acceptableTransportCandidate(rc, this.offeredCandidates)) {
            List<TransportCandidate> list = this.remoteCandidates;
            synchronized (list) {
                this.remoteCandidates.add(rc);
            }
            this.checkRemoteCandidate(rc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOfferedCandidate(TransportCandidate rc) {
        if (rc != null) {
            List<TransportCandidate> list = this.offeredCandidates;
            synchronized (list) {
                this.offeredCandidates.add(rc);
            }
        }
    }

    private void checkRemoteCandidate(final TransportCandidate offeredCandidate) {
        offeredCandidate.addListener(new TransportResolverListener.Checker(){

            public void candidateChecked(TransportCandidate cand, boolean validCandidate) {
                if (validCandidate && TransportNegotiator.this.getNegotiatorState() == JingleNegotiatorState.PENDING) {
                    TransportNegotiator.this.addValidRemoteCandidate(offeredCandidate);
                }
            }

            public void candidateChecking(TransportCandidate cand) {
            }
        });
        offeredCandidate.check(this.resolver.getCandidatesList());
    }

    private boolean isEstablished() {
        return this.getBestRemoteCandidate() != null && this.getAcceptedLocalCandidate() != null;
    }

    public final boolean isFullyEstablished() {
        return this.isEstablished() && (this.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED || this.getNegotiatorState() == JingleNegotiatorState.FAILED);
    }

    private void delayedCheckBestCandidate(final JingleSession js, final Jingle jin) {
        if (this.resultThread == null && !this.getRemoteCandidates().isEmpty()) {
            this.resultThread = new Thread(new Runnable(){

                public void run() {
                    TransportCandidate bestRemote;
                    int totalTime = 7000;
                    int tries = (int)Math.ceil(totalTime / 1000);
                    for (int i = 0; i < tries - 1; ++i) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        TransportCandidate bestRemote2 = TransportNegotiator.this.getBestRemoteCandidate();
                        if (bestRemote2 == null || TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.PENDING) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(bestRemote2)) {
                            Jingle jout = new Jingle(JingleActionEnum.CONTENT_ACCEPT);
                            JingleContent content = TransportNegotiator.this.parentNegotiator.getJingleContent();
                            content.addJingleTransport(TransportNegotiator.this.getJingleTransport(bestRemote2));
                            jout.addContent(content);
                            js.sendFormattedJingle(jin, jout);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(bestRemote2);
                        }
                        if (!TransportNegotiator.this.isEstablished() || TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.PENDING) continue;
                        TransportNegotiator.this.setNegotiatorState(JingleNegotiatorState.SUCCEEDED);
                        TransportNegotiator.this.triggerTransportEstablished(TransportNegotiator.this.getAcceptedLocalCandidate(), bestRemote2);
                        break;
                    }
                    if ((bestRemote = TransportNegotiator.this.getBestRemoteCandidate()) == null) {
                        boolean foundRemoteRelay = false;
                        for (TransportCandidate candidate : TransportNegotiator.this.remoteCandidates) {
                            ICECandidate iceCandidate;
                            if (!(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals("relay")) continue;
                            TransportNegotiator.this.addValidRemoteCandidate(iceCandidate);
                            foundRemoteRelay = true;
                        }
                        if (!foundRemoteRelay) {
                            boolean foundLocalRelay = false;
                            for (TransportCandidate candidate : TransportNegotiator.this.offeredCandidates) {
                                ICECandidate iceCandidate;
                                if (!(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals("relay")) continue;
                                foundLocalRelay = true;
                            }
                            if (foundLocalRelay) {
                                ICECandidate iceCandidate;
                                boolean foundRemotePublic = false;
                                for (TransportCandidate candidate : TransportNegotiator.this.remoteCandidates) {
                                    if (!(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals((Object)ICECandidate.Type.srflx)) continue;
                                    TransportNegotiator.this.addValidRemoteCandidate(iceCandidate);
                                    foundRemotePublic = true;
                                }
                                if (!foundRemotePublic) {
                                    for (TransportCandidate candidate : TransportNegotiator.this.remoteCandidates) {
                                        if (!(candidate instanceof ICECandidate)) continue;
                                        iceCandidate = (ICECandidate)candidate;
                                        TransportNegotiator.this.addValidRemoteCandidate(iceCandidate);
                                    }
                                }
                            }
                        }
                    }
                    for (int i = 0; i < 6; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        bestRemote = TransportNegotiator.this.getBestRemoteCandidate();
                        if (bestRemote == null || TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.PENDING) continue;
                        if (!TransportNegotiator.this.acceptedRemoteCandidates.contains(bestRemote)) {
                            Jingle jout = new Jingle(JingleActionEnum.CONTENT_ACCEPT);
                            JingleContent content = TransportNegotiator.this.parentNegotiator.getJingleContent();
                            content.addJingleTransport(TransportNegotiator.this.getJingleTransport(bestRemote));
                            jout.addContent(content);
                            js.sendFormattedJingle(jin, jout);
                            TransportNegotiator.this.acceptedRemoteCandidates.add(bestRemote);
                        }
                        if (!TransportNegotiator.this.isEstablished()) continue;
                        TransportNegotiator.this.setNegotiatorState(JingleNegotiatorState.SUCCEEDED);
                        break;
                    }
                    if (TransportNegotiator.this.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) {
                        try {
                            TransportNegotiator.this.session.terminate("Unable to negotiate session. This may be caused by firewall configuration problems.");
                        }
                        catch (XMPPException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, "Waiting for all the transport candidates checks...");
            this.resultThread.setName("Transport Resolver Result");
            this.resultThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidRemoteCandidate(TransportCandidate remoteCandidate) {
        if (remoteCandidate != null) {
            List<TransportCandidate> list = this.validRemoteCandidates;
            synchronized (list) {
                LOGGER.debug("Added valid candidate: " + remoteCandidate.getIp() + ":" + remoteCandidate.getPort());
                this.validRemoteCandidates.add(remoteCandidate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayList getValidRemoteCandidatesList() {
        List<TransportCandidate> list = this.validRemoteCandidates;
        synchronized (list) {
            return new ArrayList<TransportCandidate>(this.validRemoteCandidates);
        }
    }

    public final Iterator getValidRemoteCandidates() {
        return Collections.unmodifiableList(this.getRemoteCandidates()).iterator();
    }

    private void addRemoteCandidates(List rc) {
        if (rc != null && rc.size() > 0) {
            for (Object aRc : rc) {
                this.addRemoteCandidate((TransportCandidate)aRc);
            }
        }
    }

    private List<TransportCandidate> obtainCandidatesList(Jingle jingle) {
        ArrayList<TransportCandidate> result = new ArrayList<TransportCandidate>();
        if (jingle != null) {
            for (JingleContent jingleContent : jingle.getContentsList()) {
                if (!jingleContent.getName().equals(this.parentNegotiator.getName())) continue;
                for (JingleTransport jingleTransport : jingleContent.getJingleTransportsList()) {
                    for (JingleTransport.JingleTransportCandidate jingleTransportCandidate : jingleTransport.getCandidatesList()) {
                        TransportCandidate transCand = jingleTransportCandidate.getMediaTransport();
                        result.add(transCand);
                    }
                }
            }
        }
        return result;
    }

    private boolean isOfferStarted() {
        return this.resolver.isResolving() || this.resolver.isResolved();
    }

    private synchronized void sendTransportCandidateOffer(TransportCandidate cand) {
        if (!cand.isNull()) {
            this.addOfferedCandidate(cand);
            JingleContent content = this.parentNegotiator.getJingleContent();
            content.addJingleTransport(this.getJingleTransport(cand));
            Jingle jingle = new Jingle(JingleActionEnum.TRANSPORT_INFO);
            jingle.addContent(content);
            this.session.sendFormattedJingle(jingle);
        }
    }

    private void sendTransportCandidatesOffer() throws XMPPException {
        List<TransportCandidate> notOffered = this.resolver.getCandidatesList();
        notOffered.removeAll(this.offeredCandidates);
        for (TransportCandidate aNotOffered : notOffered) {
            this.sendTransportCandidateOffer(aNotOffered);
        }
        if (this.resolverListener == null) {
            this.resolverListener = new TransportResolverListener.Resolver(){

                public void candidateAdded(TransportCandidate cand) {
                    TransportNegotiator.this.sendTransportCandidateOffer(cand);
                }

                public void end() {
                }

                public void init() {
                }
            };
            this.resolver.addListener(this.resolverListener);
        }
        if (!this.resolver.isResolving() && !this.resolver.isResolved()) {
            LOGGER.debug("RESOLVER CALLED");
            this.resolver.resolve(this.session);
        }
    }

    @Override
    public final List<IQ> dispatchIncomingPacket(IQ iq, String id) throws XMPPException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        Jingle response = null;
        if (iq != null) {
            if (iq.getType().equals(IQ.Type.ERROR)) {
                this.setNegotiatorState(JingleNegotiatorState.FAILED);
                this.triggerTransportClosed(null);
                throw new JingleException(iq.getError().getMessage());
            }
            if (iq.getType().equals(IQ.Type.RESULT)) {
                if (this.isExpectedId(iq.getPacketID())) {
                    response = this.receiveResult(iq);
                    this.removeExpectedId(iq.getPacketID());
                }
            } else if (iq instanceof Jingle) {
                Jingle jingle = (Jingle)iq;
                JingleActionEnum action = jingle.getAction();
                switch (action) {
                    case CONTENT_ACCEPT: {
                        response = this.receiveContentAcceptAction(jingle);
                        break;
                    }
                    case CONTENT_MODIFY: {
                        break;
                    }
                    case CONTENT_REMOVE: {
                        break;
                    }
                    case SESSION_INFO: {
                        break;
                    }
                    case SESSION_INITIATE: {
                        response = this.receiveSessionInitiateAction(jingle);
                        break;
                    }
                    case SESSION_ACCEPT: {
                        response = this.receiveSessionAcceptAction(jingle);
                        break;
                    }
                    case TRANSPORT_INFO: {
                        response = this.receiveTransportInfoAction(jingle);
                        break;
                    }
                }
            }
        }
        if (response != null) {
            this.addExpectedId(response.getPacketID());
            responses.add(response);
        }
        return responses;
    }

    private Jingle receiveResult(IQ iq) throws XMPPException {
        Jingle response = null;
        this.sendTransportCandidatesOffer();
        this.setNegotiatorState(JingleNegotiatorState.PENDING);
        return response;
    }

    private IQ receiveSessionInitiateAction(Jingle jingle) throws XMPPException {
        IQ response = null;
        this.sendTransportCandidatesOffer();
        this.delayedCheckBestCandidate(this.session, jingle);
        this.setNegotiatorState(JingleNegotiatorState.PENDING);
        return response;
    }

    private IQ receiveTransportInfoAction(Jingle jingle) throws XMPPException {
        IQ response = null;
        this.addRemoteCandidates(this.obtainCandidatesList(jingle));
        this.delayedCheckBestCandidate(this.session, jingle);
        response = this.session.createAck(jingle);
        return response;
    }

    private IQ receiveContentAcceptAction(Jingle jingle) throws XMPPException {
        IQ response = null;
        List<TransportCandidate> accepted = this.obtainCandidatesList(jingle);
        if (!accepted.isEmpty()) {
            for (TransportCandidate cand : accepted) {
                LOGGER.debug("Remote acccepted candidate addr: " + cand.getIp());
            }
            TransportCandidate cand = accepted.get(0);
            this.setAcceptedLocalCandidate(cand);
            if (this.isEstablished()) {
                LOGGER.debug(cand.getIp() + " is set active");
            }
        }
        return response;
    }

    private IQ receiveSessionAcceptAction(Jingle jingle) {
        IQ response = null;
        LOGGER.debug("Transport stabilished");
        return response;
    }

    private void triggerTransportEstablished(TransportCandidate local, TransportCandidate remote) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleTransportListener)) continue;
            JingleTransportListener mli = (JingleTransportListener)li;
            LOGGER.debug("triggerTransportEstablished " + local.getLocalIp() + ":" + local.getPort() + " <-> " + remote.getIp() + ":" + remote.getPort());
            mli.transportEstablished(local, remote);
        }
    }

    private void triggerTransportClosed(TransportCandidate cand) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleTransportListener)) continue;
            JingleTransportListener mli = (JingleTransportListener)li;
            mli.transportClosed(cand);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Ice
    extends TransportNegotiator {
        public Ice(JingleSession js, TransportResolver res, ContentNegotiator parentNegotiator) {
            super(js, res, parentNegotiator);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate candidate) {
            JingleTransport.Ice jt = new JingleTransport.Ice();
            jt.addCandidate(new JingleTransport.Ice.Candidate(candidate));
            return jt;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ICECandidate result = null;
            ArrayList cands = this.getValidRemoteCandidatesList();
            if (!cands.isEmpty()) {
                int highest = -1;
                ICECandidate chose = null;
                for (ICECandidate transportCandidate : cands) {
                    if (transportCandidate.getPreference() <= highest) continue;
                    chose = transportCandidate;
                    highest = transportCandidate.getPreference();
                }
                result = chose;
            }
            if (result != null && result.getType().equals("relay")) {
                LOGGER.debug("Relay Type");
            }
            return result;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate tc, List<TransportCandidate> localCandidates) {
            return tc instanceof ICECandidate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RawUdp
    extends TransportNegotiator {
        public RawUdp(JingleSession js, TransportResolver res, ContentNegotiator parentNegotiator) {
            super(js, res, parentNegotiator);
        }

        @Override
        public JingleTransport getJingleTransport(TransportCandidate bestRemote) {
            JingleTransport.RawUdp jt = new JingleTransport.RawUdp();
            jt.addCandidate(new JingleTransport.RawUdp.Candidate(bestRemote));
            return jt;
        }

        @Override
        public TransportCandidate getBestRemoteCandidate() {
            ArrayList cands = this.getValidRemoteCandidatesList();
            if (!cands.isEmpty()) {
                LOGGER.debug("RAW CAND");
                return (TransportCandidate)cands.get(0);
            }
            LOGGER.debug("No Remote Candidate");
            return null;
        }

        @Override
        public boolean acceptableTransportCandidate(TransportCandidate tc, List<TransportCandidate> localCandidates) {
            return tc instanceof TransportCandidate.Fixed;
        }
    }
}

