/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.media.PayloadType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JingleDescription
implements PacketExtension {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(JingleDescription.class);
    public static final String NODENAME = "description";
    private final List<PayloadType> payloads = new ArrayList<PayloadType>();

    @Override
    public String getElementName() {
        return NODENAME;
    }

    @Override
    public abstract String getNamespace();

    public abstract String getMediaType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPayloadType(PayloadType payloadType) {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            if (payloadType == null) {
                LOGGER.error("Null payload type");
            } else {
                this.payloads.add(payloadType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioPayloadTypes(List<PayloadType> list) {
        List<PayloadType> list2 = this.payloads;
        synchronized (list2) {
            for (PayloadType.Audio audio : list) {
                this.addPayloadType(new PayloadType.Audio(audio));
            }
        }
    }

    public Iterator<PayloadType> getPayloadTypes() {
        return Collections.unmodifiableList(this.getPayloadTypesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PayloadType> getPayloadTypesList() {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            return new ArrayList<PayloadType>(this.payloads);
        }
    }

    public List<PayloadType> getAudioPayloadTypesList() {
        ArrayList<PayloadType> arrayList = new ArrayList<PayloadType>();
        Iterator<PayloadType> iterator = this.getPayloadTypes();
        while (iterator.hasNext()) {
            PayloadType payloadType = iterator.next();
            if (!(payloadType instanceof PayloadType.Audio)) continue;
            PayloadType.Audio audio = (PayloadType.Audio)payloadType;
            arrayList.add(audio);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPayloadTypesCount() {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            return this.payloads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            if (this.payloads.size() > 0) {
                stringBuilder.append("<").append(this.getElementName());
                stringBuilder.append(" xmlns=\"").append(this.getNamespace()).append("\"");
                stringBuilder.append(" media=\"").append(this.getMediaType()).append("\" >");
                for (PayloadType payloadType : this.payloads) {
                    if (payloadType == null) continue;
                    stringBuilder.append(payloadType.toXML());
                }
                stringBuilder.append("</").append(this.getElementName()).append(">");
            }
        }
        return stringBuilder.toString();
    }

    public static class Audio
    extends JingleDescription {
        public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:1";
        public static final String MEDIA_TYPE = "audio";

        public Audio() {
        }

        public Audio(PayloadType payloadType) {
            this.addPayloadType(payloadType);
        }

        public String getNamespace() {
            return NAMESPACE;
        }

        public String getMediaType() {
            return MEDIA_TYPE;
        }
    }
}

