/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.test.demo.ice.ICENegociator;
import de.javawi.jstun.util.UtilityException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.nat.BridgedResolver;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.RTPBridge;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;

public class ICEResolver
extends TransportResolver {
    private static final SmackLogger LOGGER = SmackLogger.getLogger(ICEResolver.class);
    Connection connection;
    Random random = new Random();
    long sid;
    String server;
    int port;
    static Map<String, ICENegociator> negociatorsMap = new HashMap<String, ICENegociator>();

    public ICEResolver(Connection connection, String string, int n) {
        this.connection = connection;
        this.server = string;
        this.port = n;
        this.setType(TransportResolver.Type.ice);
    }

    public void initialize() throws XMPPException {
        if (!this.isResolving() && !this.isResolved()) {
            LOGGER.debug("Initialized");
            if (negociatorsMap.get(this.server) == null) {
                ICENegociator iCENegociator = new ICENegociator(this.server, this.port, 1);
                negociatorsMap.put(this.server, iCENegociator);
                iCENegociator.gatherCandidateAddresses();
                iCENegociator.prioritizeCandidates();
            }
        }
        this.setInitialized();
    }

    public void cancel() throws XMPPException {
    }

    public synchronized void resolve(JingleSession jingleSession) throws XMPPException {
        Object object;
        Object object2;
        Object object3;
        Object unknownHostException;
        this.setResolveInit();
        for (TransportCandidate object5 : this.getCandidatesList()) {
            if (!(object5 instanceof ICECandidate)) continue;
            ICECandidate iCECandidate = (ICECandidate)object5;
            iCECandidate.removeCandidateEcho();
        }
        this.clear();
        ICENegociator iCENegociator = negociatorsMap.get(this.server);
        for (ICECandidate iCECandidate : iCENegociator.getSortedCandidates()) {
            try {
                unknownHostException = iCECandidate.getCandidateType();
                object3 = ICECandidate.Type.local;
                object3 = unknownHostException.equals((Object)Candidate.CandidateType.ServerReflexive) ? ICECandidate.Type.srflx : (unknownHostException.equals((Object)Candidate.CandidateType.PeerReflexive) ? ICECandidate.Type.prflx : (unknownHostException.equals((Object)Candidate.CandidateType.Relayed) ? ICECandidate.Type.relay : ICECandidate.Type.host));
                int n = 0;
                try {
                    object2 = NetworkInterface.getNetworkInterfaces();
                    int enumeration = 0;
                    NetworkInterface bl = NetworkInterface.getByInetAddress(iCECandidate.getAddress().getInetAddress());
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        if (((NetworkInterface)object).equals(bl)) {
                            n = enumeration;
                            break;
                        }
                        enumeration = (short)(enumeration + 1);
                    }
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                }
                object2 = new ICECandidate(iCECandidate.getAddress().getInetAddress().getHostAddress(), 1, n, String.valueOf(Math.abs(this.random.nextLong())), iCECandidate.getPort(), "1", iCECandidate.getPriority(), (ICECandidate.Type)((Object)object3));
                ((TransportCandidate)object2).setLocalIp(iCECandidate.getBase().getAddress().getInetAddress().getHostAddress());
                ((TransportCandidate)object2).setPort(this.getFreePort());
                try {
                    ((TransportCandidate)object2).addCandidateEcho(jingleSession);
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                }
                this.addCandidate((TransportCandidate)object2);
                LOGGER.debug("Candidate addr: " + iCECandidate.getAddress().getInetAddress() + "|" + iCECandidate.getBase().getAddress().getInetAddress() + " Priority:" + iCECandidate.getPriority());
            }
            catch (UtilityException utilityException) {
                utilityException.printStackTrace();
            }
            catch (UnknownHostException unknownHostException2) {
                unknownHostException2.printStackTrace();
            }
        }
        if (RTPBridge.serviceAvailable(this.connection)) {
            String string = BridgedResolver.getLocalHost();
            int n = 0;
            this.sid = Math.abs(this.random.nextLong());
            unknownHostException = RTPBridge.getRTPBridge(this.connection, String.valueOf(this.sid));
            object3 = new ICECandidate(((RTPBridge)unknownHostException).getIp(), 1, n, String.valueOf(Math.abs(this.random.nextLong())), ((RTPBridge)unknownHostException).getPortA(), "1", 0, ICECandidate.Type.relay);
            ((TransportCandidate)object3).setLocalIp(string);
            ICECandidate iCECandidate = new ICECandidate(((RTPBridge)unknownHostException).getIp(), 1, n, String.valueOf(Math.abs(this.random.nextLong())), ((RTPBridge)unknownHostException).getPortB(), "1", 0, ICECandidate.Type.relay);
            iCECandidate.setLocalIp(string);
            ((TransportCandidate)object3).setSymmetric(iCECandidate);
            iCECandidate.setSymmetric((TransportCandidate)object3);
            ((TransportCandidate)object3).setPassword(((RTPBridge)unknownHostException).getPass());
            iCECandidate.setPassword(((RTPBridge)unknownHostException).getPass());
            ((TransportCandidate)object3).setSessionId(((RTPBridge)unknownHostException).getSid());
            iCECandidate.setSessionId(((RTPBridge)unknownHostException).getSid());
            ((TransportCandidate)object3).setConnection(this.connection);
            iCECandidate.setConnection(this.connection);
            this.addCandidate((TransportCandidate)object3);
            object2 = RTPBridge.getPublicIP(this.connection);
            if (object2 != null && !((String)object2).equals("")) {
                Enumeration<NetworkInterface> enumeration = null;
                try {
                    enumeration = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException socketException) {
                    socketException.printStackTrace();
                }
                boolean bl = false;
                block16: while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = ((NetworkInterface)object).getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        if (inetAddress.getHostAddress().indexOf((String)object2) <= -1) continue;
                        bl = true;
                        continue block16;
                    }
                }
                if (!bl) {
                    try {
                        object = new ICECandidate((String)object2, 1, 0, String.valueOf(Math.abs(this.random.nextLong())), this.getFreePort(), "1", 0, ICECandidate.Type.srflx);
                        ((TransportCandidate)object).setLocalIp(InetAddress.getLocalHost().getHostAddress());
                        try {
                            ((TransportCandidate)object).addCandidateEcho(jingleSession);
                        }
                        catch (SocketException socketException) {
                            socketException.printStackTrace();
                        }
                        this.addCandidate((TransportCandidate)object);
                    }
                    catch (UnknownHostException unknownHostException3) {
                        unknownHostException3.printStackTrace();
                    }
                }
            }
        }
        this.setResolveEnd();
    }
}

