/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.kenai.jbosh.BOSHClient;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.BOSHClientConnEvent;
import com.kenai.jbosh.BOSHClientConnListener;
import com.kenai.jbosh.BOSHClientRequestListener;
import com.kenai.jbosh.BOSHClientResponseListener;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BOSHMessageEvent;
import com.kenai.jbosh.BodyQName;
import com.kenai.jbosh.ComposableBody;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jivesoftware.smack.BOSHConfiguration;
import org.jivesoftware.smack.BOSHPacketReader;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class BOSHConnection
extends Connection {
    public static final String XMPP_BOSH_NS = "urn:xmpp:xbosh";
    public static final String BOSH_URI = "http://jabber.org/protocol/httpbind";
    private BOSHClient client;
    private final BOSHConfiguration config;
    private boolean connected = false;
    private boolean authenticated = false;
    private boolean anonymous = false;
    private boolean isFirstInitialization = true;
    private boolean wasAuthenticated = false;
    private boolean done = false;
    private ExecutorService listenerExecutor;
    private PipedWriter readerPipe;
    private Thread readerConsumer;
    protected String authID = null;
    protected String sessionID = null;
    private String user = null;
    private Roster roster = null;

    public BOSHConnection(boolean bl, String string, int n, String string2, String string3) {
        super(new BOSHConfiguration(bl, string, n, string2, string3));
        this.config = (BOSHConfiguration)this.getConfiguration();
    }

    public BOSHConnection(BOSHConfiguration bOSHConfiguration) {
        super(bOSHConfiguration);
        this.config = bOSHConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws XMPPException {
        Object object;
        if (this.connected) {
            throw new IllegalStateException("Already connected to a server.");
        }
        this.done = false;
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            this.saslAuthentication.init();
            this.sessionID = null;
            this.authID = null;
            object = BOSHClientConfig.Builder.create(this.config.getURI(), this.config.getServiceName());
            if (this.config.isProxyEnabled()) {
                ((BOSHClientConfig.Builder)object).setProxy(this.config.getProxyAddress(), this.config.getProxyPort());
            }
            this.client = BOSHClient.create(((BOSHClientConfig.Builder)object).build());
            this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "Smack Listener Processor (" + BOSHConnection.this.connectionCounterValue + ")");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.client.addBOSHClientConnListener(new BOSHConnectionListener(this));
            this.client.addBOSHClientResponseListener(new BOSHPacketReader(this));
            if (this.config.isDebuggerEnabled()) {
                this.initDebugger();
                if (this.isFirstInitialization) {
                    if (this.debugger.getReaderListener() != null) {
                        this.addPacketListener(this.debugger.getReaderListener(), null);
                    }
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            }
            this.client.send(ComposableBody.builder().setNamespaceDefinition("xmpp", XMPP_BOSH_NS).setAttribute(BodyQName.createWithPrefix(XMPP_BOSH_NS, "version", "xmpp"), "1.0").build());
        }
        catch (Exception exception) {
            throw new XMPPException("Can't connect to " + this.getServiceName(), exception);
        }
        object = this;
        synchronized (object) {
            long l = System.currentTimeMillis() + (long)(SmackConfiguration.getPacketReplyTimeout() * 6);
            while (!this.connected && System.currentTimeMillis() < l) {
                try {
                    this.wait(Math.abs(l - System.currentTimeMillis()));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this.connected && !this.done) {
            this.done = true;
            object = "Timeout reached for the connection to " + this.getHost() + ":" + this.getPort() + ".";
            throw new XMPPException((String)object, new XMPPError(XMPPError.Condition.remote_server_timeout, (String)object));
        }
    }

    @Override
    public String getConnectionID() {
        if (!this.connected) {
            return null;
        }
        if (this.authID != null) {
            return this.authID;
        }
        return this.sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Roster getRoster() {
        if (this.roster == null) {
            return null;
        }
        if (!this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (!this.roster.rosterInitialized) {
            try {
                Roster roster = this.roster;
                synchronized (roster) {
                    long l;
                    long l2 = System.currentTimeMillis();
                    for (long i = (long)SmackConfiguration.getPacketReplyTimeout(); !this.roster.rosterInitialized && i > 0L; i -= l - l2) {
                        this.roster.wait(i);
                        l = System.currentTimeMillis();
                        l2 = l;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.roster;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return false;
    }

    @Override
    public boolean isUsingCompression() {
        return false;
    }

    @Override
    public void login(String string, String string2, String string3) throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        string = string.toLowerCase().trim();
        String string4 = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (string2 != null ? this.saslAuthentication.authenticate(string, string2, string3) : this.saslAuthentication.authenticate(string, string3, this.config.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(string, string2, string3);
        if (string4 != null) {
            this.user = string4;
            this.config.setServiceName(StringUtils.parseServer(string4));
        } else {
            this.user = string + "@" + this.getServiceName();
            if (string3 != null) {
                this.user = this.user + "/" + string3;
            }
        }
        if (this.roster == null) {
            this.roster = this.rosterStorage == null ? new Roster(this) : new Roster(this, this.rosterStorage);
        }
        if (this.config.isRosterLoadedAtLogin()) {
            this.roster.reload();
        }
        if (this.config.isSendPresence()) {
            this.sendPacket(new Presence(Presence.Type.available));
        }
        this.authenticated = true;
        this.anonymous = false;
        this.config.setLoginInfo(string, string2, string3);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    @Override
    public void loginAnonymously() throws XMPPException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Already logged in to server.");
        }
        String string = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
        this.user = string;
        this.config.setServiceName(StringUtils.parseServer(string));
        this.roster = null;
        if (this.config.isSendPresence()) {
            this.sendPacket(new Presence(Presence.Type.available));
        }
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
    }

    @Override
    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        if (!this.done) {
            this.firePacketInterceptors(packet);
            try {
                this.send(ComposableBody.builder().setPayloadXML(packet.toXML()).build());
            }
            catch (BOSHException bOSHException) {
                bOSHException.printStackTrace();
                return;
            }
            this.firePacketSendingListeners(packet);
        }
    }

    @Override
    public void disconnect(Presence presence) {
        if (!this.connected) {
            return;
        }
        this.shutdown(presence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.sendListeners.clear();
        this.recvListeners.clear();
        this.collectors.clear();
        this.interceptors.clear();
        this.wasAuthenticated = false;
        this.isFirstInitialization = true;
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            try {
                connectionListener.connectionClosed();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void shutdown(Presence presence) {
        this.setWasAuthenticated(this.authenticated);
        this.authID = null;
        this.sessionID = null;
        this.done = true;
        this.authenticated = false;
        this.connected = false;
        this.isFirstInitialization = false;
        try {
            this.client.disconnect(ComposableBody.builder().setNamespaceDefinition("xmpp", XMPP_BOSH_NS).setPayloadXML(presence.toXML()).build());
            Thread.sleep(150L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.readerPipe != null) {
            try {
                this.readerPipe.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writer = null;
        }
        if (this.listenerExecutor != null) {
            this.listenerExecutor.shutdown();
        }
        this.readerConsumer = null;
    }

    private void setWasAuthenticated(boolean bl) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = bl;
        }
    }

    protected void send(ComposableBody composableBody) throws BOSHException {
        if (!this.connected) {
            throw new IllegalStateException("Not connected to a server!");
        }
        if (composableBody == null) {
            throw new NullPointerException("Body mustn't be null!");
        }
        if (this.sessionID != null) {
            composableBody = composableBody.rebuild().setAttribute(BodyQName.create(BOSH_URI, "sid"), this.sessionID).build();
        }
        this.client.send(composableBody);
    }

    protected void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        for (PacketCollector packetCollector : this.getPacketCollectors()) {
            packetCollector.processPacket(packet);
        }
        this.listenerExecutor.submit(new ListenerNotification(packet));
    }

    @Override
    protected void initDebugger() {
        this.writer = new Writer(){

            @Override
            public void write(char[] cArray, int n, int n2) {
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }
        };
        try {
            this.readerPipe = new PipedWriter();
            this.reader = new PipedReader(this.readerPipe);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.initDebugger();
        this.client.addBOSHClientResponseListener(new BOSHClientResponseListener(){

            @Override
            public void responseReceived(BOSHMessageEvent bOSHMessageEvent) {
                if (bOSHMessageEvent.getBody() != null) {
                    try {
                        BOSHConnection.this.readerPipe.write(bOSHMessageEvent.getBody().toXML());
                        BOSHConnection.this.readerPipe.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.client.addBOSHClientRequestListener(new BOSHClientRequestListener(){

            @Override
            public void requestSent(BOSHMessageEvent bOSHMessageEvent) {
                if (bOSHMessageEvent.getBody() != null) {
                    try {
                        BOSHConnection.this.writer.write(bOSHMessageEvent.getBody().toXML());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.readerConsumer = new Thread(){
            private Thread thread = this;
            private int bufferLength = 1024;

            @Override
            public void run() {
                try {
                    char[] cArray = new char[this.bufferLength];
                    while (BOSHConnection.this.readerConsumer == this.thread && !BOSHConnection.this.done) {
                        BOSHConnection.this.reader.read(cArray, 0, this.bufferLength);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.readerConsumer.setDaemon(true);
        this.readerConsumer.start();
    }

    protected void notifyConnectionError(Exception exception) {
        this.shutdown(new Presence(Presence.Type.unavailable));
        exception.printStackTrace();
        for (ConnectionListener connectionListener : this.getConnectionListeners()) {
            try {
                connectionListener.connectionClosedOnError(exception);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
    }

    @Override
    public void setRosterStorage(RosterStorage rosterStorage) throws IllegalStateException {
        if (this.roster != null) {
            throw new IllegalStateException("Roster is already initialized");
        }
        this.rosterStorage = rosterStorage;
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            for (Connection.ListenerWrapper listenerWrapper : BOSHConnection.this.recvListeners.values()) {
                listenerWrapper.notifyListener(this.packet);
            }
        }
    }

    private class BOSHConnectionListener
    implements BOSHClientConnListener {
        private final BOSHConnection connection;

        public BOSHConnectionListener(BOSHConnection bOSHConnection2) {
            this.connection = bOSHConnection2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionEvent(BOSHClientConnEvent bOSHClientConnEvent) {
            block20: {
                try {
                    if (bOSHClientConnEvent.isConnected()) {
                        BOSHConnection.this.connected = true;
                        if (BOSHConnection.this.isFirstInitialization) {
                            BOSHConnection.this.isFirstInitialization = false;
                            for (ConnectionCreationListener connectionCreationListener : Connection.getConnectionCreationListeners()) {
                                connectionCreationListener.connectionCreated(this.connection);
                            }
                            break block20;
                        }
                        try {
                            if (BOSHConnection.this.wasAuthenticated) {
                                this.connection.login(BOSHConnection.this.config.getUsername(), BOSHConnection.this.config.getPassword(), BOSHConnection.this.config.getResource());
                            }
                            for (ConnectionListener connectionListener : BOSHConnection.this.getConnectionListeners()) {
                                connectionListener.reconnectionSuccessful();
                            }
                            break block20;
                        }
                        catch (XMPPException xMPPException) {
                            for (ConnectionListener connectionListener : BOSHConnection.this.getConnectionListeners()) {
                                connectionListener.reconnectionFailed(xMPPException);
                            }
                            break block20;
                        }
                    }
                    if (bOSHClientConnEvent.isError()) {
                        try {
                            bOSHClientConnEvent.getCause();
                        }
                        catch (Exception exception) {
                            BOSHConnection.this.notifyConnectionError(exception);
                        }
                    }
                    BOSHConnection.this.connected = false;
                }
                finally {
                    Iterator<ConnectionListener> iterator = this.connection;
                    synchronized (iterator) {
                        this.connection.notifyAll();
                    }
                }
            }
        }
    }
}

