/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;

public class RoomTransfer
implements PacketExtension {
    public static final String ELEMENT_NAME = "transfer";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private Type type;
    private String invitee;
    private String inviter;
    private String sessionID;
    private String room;
    private String reason;

    public RoomTransfer(Type type, String string, String string2, String string3) {
        this.type = type;
        this.invitee = string;
        this.sessionID = string2;
        this.reason = string3;
    }

    private RoomTransfer() {
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getInviter() {
        return this.inviter;
    }

    public String getRoom() {
        return this.room;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE);
        stringBuilder.append("\" type=\"").append((Object)this.type).append("\">");
        stringBuilder.append("<session xmlns=\"http://jivesoftware.com/protocol/workgroup\" id=\"").append(this.sessionID).append("\"></session>");
        if (this.invitee != null) {
            stringBuilder.append("<invitee>").append(this.invitee).append("</invitee>");
        }
        if (this.inviter != null) {
            stringBuilder.append("<inviter>").append(this.inviter).append("</inviter>");
        }
        if (this.reason != null) {
            stringBuilder.append("<reason>").append(this.reason).append("</reason>");
        }
        stringBuilder.append("</").append(ELEMENT_NAME).append("> ");
        return stringBuilder.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        public PacketExtension parseExtension(XmlPullParser xmlPullParser) throws Exception {
            RoomTransfer roomTransfer = new RoomTransfer();
            roomTransfer.type = Type.valueOf(xmlPullParser.getAttributeValue("", "type"));
            boolean bl = false;
            while (!bl) {
                xmlPullParser.next();
                String string = xmlPullParser.getName();
                if (xmlPullParser.getEventType() == 2) {
                    if ("session".equals(string)) {
                        roomTransfer.sessionID = xmlPullParser.getAttributeValue("", "id");
                        continue;
                    }
                    if ("invitee".equals(string)) {
                        roomTransfer.invitee = xmlPullParser.nextText();
                        continue;
                    }
                    if ("inviter".equals(string)) {
                        roomTransfer.inviter = xmlPullParser.nextText();
                        continue;
                    }
                    if ("reason".equals(string)) {
                        roomTransfer.reason = xmlPullParser.nextText();
                        continue;
                    }
                    if (!"room".equals(string)) continue;
                    roomTransfer.room = xmlPullParser.nextText();
                    continue;
                }
                if (xmlPullParser.getEventType() != 3 || !RoomTransfer.ELEMENT_NAME.equals(string)) continue;
                bl = true;
            }
            return roomTransfer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        user,
        queue,
        workgroup;

    }
}

