package com.beem.project.beem.jingle;

import java.util.ArrayList;
import java.util.List;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.SmackLogger;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.mediaimpl.test.TestMediaSession;
import org.jivesoftware.smackx.jingle.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

public class ReceiverMediaManager extends JingleMediaManager {
	
	private static final SmackLogger LOGGER = SmackLogger.getLogger(ReceiverMediaManager.class);

	public static final String MEDIA_NAME = "69Test";
	
	private List<PayloadType> payloads;

	public ReceiverMediaManager(JingleTransportManager transportManager) {
		super(transportManager);
		// TODO Auto-generated constructor stub
		setupPayloads();
		LOGGER.info("A TestMedia Manager is created");
	}

	@Override
	public JingleMediaSession createMediaSession(PayloadType payloadType,
			TransportCandidate remote, TransportCandidate local,
			JingleSession jingleSession) {
		// TODO Auto-generated method stub
		return new TestMediaSession(payloadType, remote, local, null, jingleSession);
	}

	@Override
	public List<PayloadType> getPayloads() {
		// TODO Auto-generated method stub
		return payloads;
	}

	private void setupPayloads() {
		payloads = new ArrayList<PayloadType>();
		payloads.add(new PayloadType.Audio(42, "Test"));
		payloads.add(new PayloadType.Audio(69, "Test2"));
	}
	
	public String getName() {
		return MEDIA_NAME;
	}
}
