/**
    BEEM is a videoconference application on the Android Platform.

    Copyright (C) 2009 by Frederic-Charles Barthelery,
                          Jean-Manuel Da Silva,
                          Nikita Kozlov,
                          Philippe Lago,
                          Jean Baptiste Vergely,
                          Vincent Véronis.

    This file is part of BEEM.

    BEEM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BEEM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BEEM.  If not, see <http://www.gnu.org/licenses/>.

    Please send bug reports with examples or suggestions to
    contact@beem-project.com or http://dev.beem-project.com/

    Epitech, hereby disclaims all copyright interest in the program “Beem”
    written by Frederic-Charles Barthelery,
               Jean-Manuel Da Silva,
               Nikita Kozlov,
               Philippe Lago,
               Jean Baptiste Vergely,
               Vincent Veronis.

    Nicolas Sadirac, November 26, 2009
    President of Epitech.

    Flavien Astraud, November 26, 2009
    Head of the EIP Laboratory.

*/
package com.beem.project.beem.jingle;

import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.media.JingleMediaSession;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

// TODO: Auto-generated Javadoc
/**
 * Manage microphone RTP session.
 * @author nikita
 */
public class MicrophoneRTPSession extends JingleMediaSession {

    private RTPTransmitter mTransmitter;
    private RTPReceiver mReceiver;

    /**
     * constructor.
     * @param payloadType the payload typ used
     * @param remote the remote transport info
     * @param local the local tranport info
     * @param mediaLocator don't know
     * @param jingleSession the current jingle session
     */
    public MicrophoneRTPSession(final PayloadType payloadType, final TransportCandidate remote,
	final TransportCandidate local, final String mediaLocator, final JingleSession jingleSession) {
	super(payloadType, remote, local, mediaLocator, jingleSession);

	// TODO le transmitter ne devrait peut etre pas etre init ici, c'est
	// peut etre encore un peu tot, a voir.
	mTransmitter = new PCMTransmitter(remote.getIp(), getRemote().getPort());
	// mReceiver = new MicroRTPReceiver(getLocal().getPort());
    }

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaSession#initialize()
     */
    @Override
    public void initialize() {
	// TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaSession#setTrasmit(boolean)
     */
    @Override
    public void setTrasmit(boolean active) {
    }

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaSession#startReceive()
     */
    @Override
    public void startReceive() {

    }

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaSession#startTrasmit()
     */
    @Override
    public void startTrasmit() {

    }

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaSession#stopReceive()
     */
    @Override
    public void stopReceive() {
	if (mReceiver != null) {
	    mReceiver.stop();
	}
    }

    /* (non-Javadoc)
     * @see org.jivesoftware.smackx.jingle.media.JingleMediaSession#stopTrasmit()
     */
    @Override
    public void stopTrasmit() {
	if (mTransmitter != null) {
	    mTransmitter.stop();
	}
    }
}
