/**

g722_encode_state_t *g722_encode_init(g722_encode_state_t *s, int rate, int options);
int g722_encode_release(g722_encode_state_t *s);
int g722_encode(g722_encode_state_t *s, uint8_t g722_data[], const int16_t amp[], int len);

g722_decode_state_t *g722_decode_init(g722_decode_state_t *s, int rate, int options);
int g722_decode_release(g722_decode_state_t *s);
int g722_decode(g722_decode_state_t *s, int16_t amp[], const uint8_t g722_data[], int len);

*/

#include <jni.h>
#include "g722.h"

jlong
Java_org_sipdroid_media_codecs_G722JNI_encodeInit(JNIEnv *env, jlong jg722State, jint rate, jint options)
{
	return g722_encode_init((void *) jg722State, rate, options);
}

jint
Java_org_sipdroid_media_codecs_G722JNI_encodeRelease(JNIEnv *env, jlong jg722State)
{
	return g722_encode_release((void *) jg722State);
}

jint
Java_org_sipdroid_media_codecs_G722JNI_encode(JNIEnv *env, jlong  jg722State, jshortArray jsignal, jlong jsrcPos, jbyteArray jg722Byte, jlong jdestPos, jint len)
{
	jshort *signal;
	jbyte *g722Byte;
	jboolean isCopyByte;
	jboolean isCopySignal;
	void *ctx = (void *) jg722State;
	jint res;

	g722Byte = (*env)->GetByteArrayElements(env, jg722Byte, &isCopyByte);
	signal = (*env)->GetShortArrayElements(env, jsignal, &isCopySignal);

	res = g722_encode(ctx, g722Byte + jdestPos, signal + jsrcPos, len);
	if (isCopyByte == JNI_TRUE)
		(*env)->ReleaseByteArrayElements(env, jg722Byte, g722Byte, 0);
	if (isCopySignal == JNI_TRUE)
		(*env)->ReleaseShortArrayElements(env, jsignal, signal, 0);
	return res;
}

jlong
Java_org_sipdroid_media_codecs_G722JNI_decodeInit(JNIEnv *env, jlong jg722State, jint rate, jint options)
{
	return g722_decode_init((void *) jg722State, rate, options);
}

jint
Java_org_sipdroid_media_codecs_G722JNI_decodeRelease(JNIEnv *env, jlong jg722State)
{
	return g722_decode_release((void *) jg722State);
}

jint
Java_org_sipdroid_media_codecs_G722JNI_decode(JNIEnv *env, jlong  jg722State, jbyteArray jg722Byte, jlong jsrcPos, jshortArray jsignal, jlong jdestPos, jint len)
{
	jshort *signal;
	jbyte *g722Byte;
	jboolean isCopyByte;
	jboolean isCopySignal;
	void *ctx = (void *) jg722State;
	jint res;

	g722Byte = (*env)->GetByteArrayElements(env, jg722Byte, &isCopyByte);
	signal = (*env)->GetShortArrayElements(env, jsignal, &isCopySignal);

	res = g722_decode(ctx, signal + jdestPos, g722Byte + jsrcPos, len);
	if (isCopyByte == JNI_TRUE)
		(*env)->ReleaseByteArrayElements(env, jg722Byte, g722Byte, 0);
	if (isCopySignal == JNI_TRUE)
		(*env)->ReleaseShortArrayElements(env, jsignal, signal, 0);
	return res;
}
