/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JingleTransport
implements PacketExtension {
    public static final String NODENAME = "transport";
    protected String namespace;
    protected final List<JingleTransportCandidate> candidates = new ArrayList<JingleTransportCandidate>();

    public JingleTransport() {
    }

    public JingleTransport(JingleTransportCandidate jingleTransportCandidate) {
        this.addCandidate(jingleTransportCandidate);
    }

    public JingleTransport(JingleTransport jingleTransport) {
        if (jingleTransport != null) {
            this.namespace = jingleTransport.namespace;
            if (jingleTransport.candidates.size() > 0) {
                this.candidates.addAll(jingleTransport.candidates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCandidate(JingleTransportCandidate jingleTransportCandidate) {
        if (jingleTransportCandidate != null) {
            List<JingleTransportCandidate> list = this.candidates;
            synchronized (list) {
                this.candidates.add(jingleTransportCandidate);
            }
        }
    }

    public Iterator getCandidates() {
        return Collections.unmodifiableList(this.getCandidatesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleTransportCandidate> getCandidatesList() {
        ArrayList<JingleTransportCandidate> arrayList = null;
        List<JingleTransportCandidate> list = this.candidates;
        synchronized (list) {
            arrayList = new ArrayList<JingleTransportCandidate>(this.candidates);
        }
        return arrayList;
    }

    public int getCandidatesCount() {
        return this.getCandidatesList().size();
    }

    @Override
    public String getElementName() {
        return NODENAME;
    }

    protected void setNamespace(String string) {
        this.namespace = string;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(this.getElementName()).append(" xmlns=\"");
        stringBuilder.append(this.getNamespace()).append("\" ");
        List<JingleTransportCandidate> list = this.candidates;
        synchronized (list) {
            if (this.getCandidatesCount() > 0) {
                stringBuilder.append(">");
                Iterator iterator = this.getCandidates();
                while (iterator.hasNext()) {
                    JingleTransportCandidate jingleTransportCandidate = (JingleTransportCandidate)iterator.next();
                    stringBuilder.append(jingleTransportCandidate.toXML());
                }
                stringBuilder.append("</").append(this.getElementName()).append(">");
            } else {
                stringBuilder.append("/>");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RawUdp
    extends JingleTransport {
        public static final String NAMESPACE = "urn:xmpp:jingle:transports:raw-udp:1";

        public RawUdp() {
            this.setNamespace(NAMESPACE);
        }

        @Override
        public void addCandidate(JingleTransportCandidate jingleTransportCandidate) {
            this.candidates.clear();
            super.addCandidate(jingleTransportCandidate);
        }

        @Override
        public List<JingleTransportCandidate> getCandidatesList() {
            ArrayList<JingleTransportCandidate> arrayList = new ArrayList<JingleTransportCandidate>();
            List<JingleTransportCandidate> list = super.getCandidatesList();
            if (list.size() > 0) {
                arrayList.add(list.get(0));
            }
            return arrayList;
        }

        public static class Candidate
        extends JingleTransportCandidate {
            public Candidate() {
            }

            public Candidate(TransportCandidate transportCandidate) {
                super(transportCandidate);
            }

            protected String getChildElements() {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.transportCandidate != null && this.transportCandidate instanceof TransportCandidate.Fixed) {
                    TransportCandidate.Fixed fixed = (TransportCandidate.Fixed)this.transportCandidate;
                    stringBuilder.append(" generation=\"").append(fixed.getGeneration()).append("\"");
                    stringBuilder.append(" ip=\"").append(fixed.getIp()).append("\"");
                    stringBuilder.append(" port=\"").append(fixed.getPort()).append("\"");
                    String string = fixed.getName();
                    if (string != null) {
                        stringBuilder.append(" name=\"").append(string).append("\"");
                    }
                }
                return stringBuilder.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ice
    extends JingleTransport {
        public static final String NAMESPACE = "urn:xmpp:jingle:transports:ice-udp:1";

        public Ice() {
            this.setNamespace(NAMESPACE);
        }

        @Override
        public void addCandidate(JingleTransportCandidate jingleTransportCandidate) {
            super.addCandidate(jingleTransportCandidate);
        }

        @Override
        public List<JingleTransportCandidate> getCandidatesList() {
            ArrayList<JingleTransportCandidate> arrayList = new ArrayList<JingleTransportCandidate>();
            List<JingleTransportCandidate> list = super.getCandidatesList();
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
            return arrayList;
        }

        public static class Candidate
        extends JingleTransportCandidate {
            public Candidate() {
            }

            public Candidate(TransportCandidate transportCandidate) {
                super(transportCandidate);
            }

            protected String getChildElements() {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.transportCandidate != null) {
                    ICECandidate iCECandidate = (ICECandidate)this.transportCandidate;
                    stringBuilder.append(" generation=\"").append(iCECandidate.getGeneration()).append("\"");
                    stringBuilder.append(" ip=\"").append(iCECandidate.getIp()).append("\"");
                    stringBuilder.append(" port=\"").append(iCECandidate.getPort()).append("\"");
                    stringBuilder.append(" network=\"").append(iCECandidate.getNetwork()).append("\"");
                    stringBuilder.append(" username=\"").append(iCECandidate.getUsername()).append("\"");
                    stringBuilder.append(" password=\"").append(iCECandidate.getPassword()).append("\"");
                    stringBuilder.append(" preference=\"").append(iCECandidate.getPreference()).append("\"");
                    stringBuilder.append(" type=\"").append((Object)iCECandidate.getType()).append("\"");
                    if (this.transportCandidate.getName() != null) {
                        stringBuilder.append(" name=\"").append(iCECandidate.getName()).append("\"");
                    }
                }
                return stringBuilder.toString();
            }
        }
    }

    public static abstract class JingleTransportCandidate {
        public static final String NODENAME = "candidate";
        protected TransportCandidate transportCandidate;

        public JingleTransportCandidate() {
        }

        public JingleTransportCandidate(TransportCandidate transportCandidate) {
            this.setMediaTransport(transportCandidate);
        }

        public static String getElementName() {
            return NODENAME;
        }

        public TransportCandidate getMediaTransport() {
            return this.transportCandidate;
        }

        public void setMediaTransport(TransportCandidate transportCandidate) {
            if (transportCandidate != null) {
                this.transportCandidate = transportCandidate;
            }
        }

        protected String getChildElements() {
            return null;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getChildElements();
            if (this.transportCandidate != null && string != null) {
                stringBuilder.append("<").append(JingleTransportCandidate.getElementName()).append(" ");
                stringBuilder.append(string);
                stringBuilder.append("/>");
            }
            return stringBuilder.toString();
        }
    }
}

