/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.jivesoftware.smack.util.Base64;

public class StringUtils {
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] APOS_ENCODE = "&apos;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    private static MessageDigest digest = null;
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String parseName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("@");
        if (n <= 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String parseServer(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("@");
        if (n + 1 > string.length()) {
            return "";
        }
        int n2 = string.indexOf("/");
        if (n2 > 0 && n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string.substring(n + 1);
    }

    public static String parseResource(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("/");
        if (n + 1 > string.length() || n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String parseBareAddress(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("/");
        if (n < 0) {
            return string;
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String escapeNode(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\22");
                    continue block11;
                }
                case '&': {
                    stringBuilder.append("\\26");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\27");
                    continue block11;
                }
                case '/': {
                    stringBuilder.append("\\2f");
                    continue block11;
                }
                case ':': {
                    stringBuilder.append("\\3a");
                    continue block11;
                }
                case '<': {
                    stringBuilder.append("\\3c");
                    continue block11;
                }
                case '>': {
                    stringBuilder.append("\\3e");
                    continue block11;
                }
                case '@': {
                    stringBuilder.append("\\40");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\5c");
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        stringBuilder.append("\\20");
                        continue block11;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String unescapeNode(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        int n = cArray.length;
        block12: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i + 2 < n) {
                char c2 = cArray[i + 1];
                char c3 = cArray[i + 2];
                if (c2 == '2') {
                    switch (c3) {
                        case '0': {
                            stringBuilder.append(' ');
                            i += 2;
                            continue block12;
                        }
                        case '2': {
                            stringBuilder.append('\"');
                            i += 2;
                            continue block12;
                        }
                        case '6': {
                            stringBuilder.append('&');
                            i += 2;
                            continue block12;
                        }
                        case '7': {
                            stringBuilder.append('\'');
                            i += 2;
                            continue block12;
                        }
                        case 'f': {
                            stringBuilder.append('/');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '3') {
                    switch (c3) {
                        case 'a': {
                            stringBuilder.append(':');
                            i += 2;
                            continue block12;
                        }
                        case 'c': {
                            stringBuilder.append('<');
                            i += 2;
                            continue block12;
                        }
                        case 'e': {
                            stringBuilder.append('>');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '4') {
                    if (c3 == '0') {
                        stringBuilder.append("@");
                        i += 2;
                        continue;
                    }
                } else if (c2 == '5' && c3 == 'c') {
                    stringBuilder.append("\\");
                    i += 2;
                    continue;
                }
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeForXML(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder((int)((double)n3 * 1.3));
        for (n = 0; n < n3; ++n) {
            char c = cArray[n];
            if (c > '>') continue;
            if (c == '<') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                n2 = n + 1;
                stringBuilder.append(LT_ENCODE);
                continue;
            }
            if (c == '>') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                n2 = n + 1;
                stringBuilder.append(GT_ENCODE);
                continue;
            }
            if (c == '&') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                if (n3 > n + 5 && cArray[n + 1] == '#' && Character.isDigit(cArray[n + 2]) && Character.isDigit(cArray[n + 3]) && Character.isDigit(cArray[n + 4]) && cArray[n + 5] == ';') continue;
                n2 = n + 1;
                stringBuilder.append(AMP_ENCODE);
                continue;
            }
            if (c == '\"') {
                if (n > n2) {
                    stringBuilder.append(cArray, n2, n - n2);
                }
                n2 = n + 1;
                stringBuilder.append(QUOTE_ENCODE);
                continue;
            }
            if (c != '\'') continue;
            if (n > n2) {
                stringBuilder.append(cArray, n2, n - n2);
            }
            n2 = n + 1;
            stringBuilder.append(APOS_ENCODE);
        }
        if (n2 == 0) {
            return string;
        }
        if (n > n2) {
            stringBuilder.append(cArray, n2, n - n2);
        }
        return stringBuilder.toString();
    }

    public static synchronized String hash(String string) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.err.println("Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
            }
        }
        try {
            digest.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
        }
        return StringUtils.encodeHex(digest.digest());
    }

    public static String encodeHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            if ((by & 0xFF) < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toString(by & 0xFF, 16));
        }
        return stringBuilder.toString();
    }

    public static String encodeBase64(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return StringUtils.encodeBase64(byArray);
    }

    public static String encodeBase64(byte[] byArray) {
        return StringUtils.encodeBase64(byArray, false);
    }

    public static String encodeBase64(byte[] byArray, boolean bl) {
        return StringUtils.encodeBase64(byArray, 0, byArray.length, bl);
    }

    public static String encodeBase64(byte[] byArray, int n, int n2, boolean bl) {
        return Base64.encodeBytes(byArray, n, n2, bl ? 0 : 8);
    }

    public static byte[] decodeBase64(String string) {
        return Base64.decode(string);
    }

    public static String randomString(int n) {
        if (n < 1) {
            return null;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(cArray);
    }

    private StringUtils() {
    }
}

