package org.sipdroid.net.tools;

import jlibrtp.DataFrame;

public class DataFramePool extends ObjectPool {

	private static DataFramePool instance = null;
	public static DataFramePool getInstance() {
		if(instance == null) {
			instance = new DataFramePool(20);
		}
		return instance;
	}
	
	public static void removeInstance() {
		instance = null;
	}
	
	protected DataFramePool(int nbObject) {
		super(nbObject);
		for(int i = 0; i < nbObject; ++i) {
			checkIn(create());
		}
	}
	
	@Override
	Object create() {
		return new DataFrame();
	}

	@Override
	boolean validate(Object o) {
		return true;
	}
	
	public DataFrame borrowFrame() {
		return (DataFrame) super.checkOut();
	}
	
	public void returnFrame(DataFrame o) {
		o.release();
		super.checkIn(o);
	}
}
