/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FaultTolerantNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiatorManager;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.StreamInitiation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferNegotiator {
    public static final String BYTE_STREAM = "http://jabber.org/protocol/bytestreams";
    public static final String INBAND_BYTE_STREAM = "http://jabber.org/protocol/ibb";
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si/profile/file-transfer", "http://jabber.org/protocol/si", "http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/ibb"};
    private static final String[] PROTOCOLS = new String[]{"http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/ibb"};
    private static final Map<Connection, FileTransferNegotiator> transferObject = new ConcurrentHashMap<Connection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator = new Random();
    public static boolean IBB_ONLY = false;
    private final Connection connection;
    private final Socks5TransferNegotiatorManager byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static FileTransferNegotiator getInstanceFor(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (!connection.isConnected()) {
            return null;
        }
        if (transferObject.containsKey(connection)) {
            return transferObject.get(connection);
        }
        FileTransferNegotiator fileTransferNegotiator = new FileTransferNegotiator(connection);
        FileTransferNegotiator.setServiceEnabled(connection, true);
        transferObject.put(connection, fileTransferNegotiator);
        return fileTransferNegotiator;
    }

    public static void setServiceEnabled(Connection connection, boolean bl) {
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        for (String string : NAMESPACE) {
            if (bl) {
                serviceDiscoveryManager.addFeature(string);
                continue;
            }
            serviceDiscoveryManager.removeFeature(string);
        }
    }

    public static boolean isServiceEnabled(Connection connection) {
        for (String string : NAMESPACE) {
            if (ServiceDiscoveryManager.getInstanceFor(connection).includesFeature(string)) continue;
            return false;
        }
        return true;
    }

    public static IQ createIQ(String string, String string2, String string3, IQ.Type type) {
        IQ iQ = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iQ.setPacketID(string);
        iQ.setTo(string2);
        iQ.setFrom(string3);
        iQ.setType(type);
        return iQ;
    }

    public static Collection<String> getSupportedProtocols() {
        return Collections.unmodifiableList(Arrays.asList(PROTOCOLS));
    }

    private FileTransferNegotiator(Connection connection) {
        this.configureConnection(connection);
        this.connection = connection;
        this.byteStreamTransferManager = new Socks5TransferNegotiatorManager(connection);
        this.inbandTransferManager = new IBBTransferNegotiator(connection);
    }

    private void configureConnection(final Connection connection) {
        connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                FileTransferNegotiator.this.cleanup(connection);
            }

            public void connectionClosedOnError(Exception exception) {
                FileTransferNegotiator.this.cleanup(connection);
            }

            public void reconnectionFailed(Exception exception) {
            }

            public void reconnectionSuccessful() {
            }

            public void reconnectingIn(int n) {
            }
        });
    }

    private void cleanup(Connection connection) {
        if (transferObject.remove(connection) != null) {
            this.byteStreamTransferManager.cleanup();
            this.inbandTransferManager.cleanup();
        }
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest fileTransferRequest) throws XMPPException {
        StreamNegotiator streamNegotiator;
        StreamInitiation streamInitiation = fileTransferRequest.getStreamInitiation();
        FormField formField = this.getStreamMethodField(streamInitiation.getFeatureNegotiationForm());
        if (formField == null) {
            String string = "No stream methods contained in packet.";
            XMPPError xMPPError = new XMPPError(XMPPError.Condition.bad_request, string);
            IQ iQ = FileTransferNegotiator.createIQ(streamInitiation.getPacketID(), streamInitiation.getFrom(), streamInitiation.getTo(), IQ.Type.ERROR);
            iQ.setError(xMPPError);
            this.connection.sendPacket(iQ);
            throw new XMPPException(string, xMPPError);
        }
        try {
            streamNegotiator = this.getNegotiator(formField);
        }
        catch (XMPPException xMPPException) {
            IQ iQ = FileTransferNegotiator.createIQ(streamInitiation.getPacketID(), streamInitiation.getFrom(), streamInitiation.getTo(), IQ.Type.ERROR);
            iQ.setError(xMPPException.getXMPPError());
            this.connection.sendPacket(iQ);
            throw xMPPException;
        }
        return streamNegotiator;
    }

    private FormField getStreamMethodField(DataForm dataForm) {
        FormField formField = null;
        Iterator<FormField> iterator = dataForm.getFields();
        while (iterator.hasNext() && !(formField = iterator.next()).getVariable().equals(STREAM_DATA_FIELD_NAME)) {
            formField = null;
        }
        return formField;
    }

    private StreamNegotiator getNegotiator(FormField formField) throws XMPPException {
        boolean bl = false;
        boolean bl2 = false;
        Object object = formField.getOptions();
        while (object.hasNext()) {
            String string = object.next().getValue();
            if (string.equals(BYTE_STREAM) && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals(INBAND_BYTE_STREAM)) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            object = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException(((XMPPError)object).getMessage(), (XMPPError)object);
        }
        if (bl && bl2 && formField.getType().equals("list-multi")) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager.createNegotiator(), this.inbandTransferManager);
        }
        if (bl) {
            return this.byteStreamTransferManager.createNegotiator();
        }
        return this.inbandTransferManager;
    }

    public void rejectStream(StreamInitiation streamInitiation) {
        XMPPError xMPPError = new XMPPError(XMPPError.Condition.forbidden, "Offer Declined");
        IQ iQ = FileTransferNegotiator.createIQ(streamInitiation.getPacketID(), streamInitiation.getFrom(), streamInitiation.getTo(), IQ.Type.ERROR);
        iQ.setError(xMPPError);
        this.connection.sendPacket(iQ);
    }

    public String getNextStreamID() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(STREAM_INIT_PREFIX);
        stringBuilder.append(Math.abs(randomGenerator.nextLong()));
        return stringBuilder.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(String string, String string2, String string3, long l, String string4, int n) throws XMPPException {
        StreamInitiation streamInitiation = new StreamInitiation();
        streamInitiation.setSesssionID(string2);
        streamInitiation.setMimeType(URLConnection.guessContentTypeFromName(string3));
        StreamInitiation.File file = new StreamInitiation.File(string3, l);
        file.setDesc(string4);
        streamInitiation.setFile(file);
        streamInitiation.setFeatureNegotiationForm(this.createDefaultInitiationForm());
        streamInitiation.setFrom(this.connection.getUser());
        streamInitiation.setTo(string);
        streamInitiation.setType(IQ.Type.SET);
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(streamInitiation.getPacketID()));
        this.connection.sendPacket(streamInitiation);
        Packet packet = packetCollector.nextResult(n);
        packetCollector.cancel();
        if (packet instanceof IQ) {
            IQ iQ = (IQ)packet;
            if (iQ.getType().equals(IQ.Type.RESULT)) {
                StreamInitiation streamInitiation2 = (StreamInitiation)packet;
                return this.getOutgoingNegotiator(this.getStreamMethodField(streamInitiation2.getFeatureNegotiationForm()));
            }
            if (iQ.getType().equals(IQ.Type.ERROR)) {
                throw new XMPPException(iQ.getError());
            }
            throw new XMPPException("File transfer response unreadable");
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField formField) throws XMPPException {
        boolean bl = false;
        boolean bl2 = false;
        Object object = formField.getValues();
        while (object.hasNext()) {
            String string = object.next();
            if (string.equals(BYTE_STREAM) && !IBB_ONLY) {
                bl = true;
                continue;
            }
            if (!string.equals(INBAND_BYTE_STREAM)) continue;
            bl2 = true;
        }
        if (!bl && !bl2) {
            object = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException(((XMPPError)object).getMessage(), (XMPPError)object);
        }
        if (bl && bl2) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager.createNegotiator(), this.inbandTransferManager);
        }
        if (bl) {
            return this.byteStreamTransferManager.createNegotiator();
        }
        return this.inbandTransferManager;
    }

    private DataForm createDefaultInitiationForm() {
        DataForm dataForm = new DataForm("form");
        FormField formField = new FormField(STREAM_DATA_FIELD_NAME);
        formField.setType("list-multi");
        if (!IBB_ONLY) {
            formField.addOption(new FormField.Option(BYTE_STREAM));
        }
        formField.addOption(new FormField.Option(INBAND_BYTE_STREAM));
        dataForm.addField(formField);
        return dataForm;
    }
}

