/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.LinkedList;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private static final int MAX_PACKETS = 65536;
    private PacketFilter packetFilter;
    private LinkedList<Packet> resultQueue;
    private Connection conection;
    private boolean cancelled = false;

    protected PacketCollector(Connection connection, PacketFilter packetFilter) {
        this.conection = connection;
        this.packetFilter = packetFilter;
        this.resultQueue = new LinkedList();
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.conection.removePacketCollector(this);
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public synchronized Packet pollResult() {
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult() {
        while (this.resultQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult(long l) {
        if (this.resultQueue.isEmpty()) {
            long l2 = System.currentTimeMillis();
            try {
                long l3;
                for (long i = l; this.resultQueue.isEmpty() && i > 0L; i -= l3 - l2) {
                    this.wait(i);
                    l3 = System.currentTimeMillis();
                    l2 = l3;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.resultQueue.isEmpty()) {
                return null;
            }
            return this.resultQueue.removeLast();
        }
        return this.resultQueue.removeLast();
    }

    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            if (this.resultQueue.size() == 65536) {
                this.resultQueue.removeLast();
            }
            this.resultQueue.addFirst(packet);
            this.notifyAll();
        }
    }
}

