/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketParserUtils {
    private static final String PROPERTIES_NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";

    public static Packet parseMessage(XmlPullParser xmlPullParser) throws Exception {
        Message message = new Message();
        String string = xmlPullParser.getAttributeValue("", "id");
        message.setPacketID(string == null ? "ID_NOT_AVAILABLE" : string);
        message.setTo(xmlPullParser.getAttributeValue("", "to"));
        message.setFrom(xmlPullParser.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(xmlPullParser.getAttributeValue("", "type")));
        String string2 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        if (string2 != null && !"".equals(string2.trim())) {
            message.setLanguage(string2);
        }
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        Map<String, Object> map = null;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string5 = xmlPullParser.getName();
                String string6 = xmlPullParser.getNamespace();
                if (string5.equals("subject")) {
                    if (string3 != null) continue;
                    string3 = xmlPullParser.nextText();
                    continue;
                }
                if (string5.equals("body")) {
                    String string7 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
                    String string8 = xmlPullParser.nextText();
                    message.addBody(string7, string8);
                    continue;
                }
                if (string5.equals("thread")) {
                    if (string4 != null) continue;
                    string4 = xmlPullParser.nextText();
                    continue;
                }
                if (string5.equals("error")) {
                    message.setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                if (string5.equals("properties") && string6.equals(PROPERTIES_NAMESPACE)) {
                    map = PacketParserUtils.parseProperties(xmlPullParser);
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(string5, string6, xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("message")) continue;
            bl = true;
        }
        message.setSubject(string3);
        message.setThread(string4);
        if (map != null) {
            for (String string5 : map.keySet()) {
                message.setProperty(string5, map.get(string5));
            }
        }
        return message;
    }

    public static Presence parsePresence(XmlPullParser xmlPullParser) throws Exception {
        Presence.Type type = Presence.Type.available;
        String string = xmlPullParser.getAttributeValue("", "type");
        if (string != null && !string.equals("")) {
            try {
                type = Presence.Type.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Found invalid presence type " + string);
            }
        }
        Presence presence = new Presence(type);
        presence.setTo(xmlPullParser.getAttributeValue("", "to"));
        presence.setFrom(xmlPullParser.getAttributeValue("", "from"));
        String string2 = xmlPullParser.getAttributeValue("", "id");
        presence.setPacketID(string2 == null ? "ID_NOT_AVAILABLE" : string2);
        String string3 = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        if (string3 != null && !"".equals(string3.trim())) {
            presence.setLanguage(string3);
        }
        presence.setPacketID(string2 == null ? "ID_NOT_AVAILABLE" : string2);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string4 = xmlPullParser.getName();
                String string5 = xmlPullParser.getNamespace();
                if (string4.equals("status")) {
                    presence.setStatus(xmlPullParser.nextText());
                    continue;
                }
                if (string4.equals("priority")) {
                    try {
                        int n2 = Integer.parseInt(xmlPullParser.nextText());
                        presence.setPriority(n2);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        presence.setPriority(0);
                    }
                    continue;
                }
                if (string4.equals("show")) {
                    String string6 = xmlPullParser.nextText();
                    try {
                        presence.setMode(Presence.Mode.valueOf(string6));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Found invalid presence mode " + string6);
                    }
                    continue;
                }
                if (string4.equals("error")) {
                    presence.setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                if (string4.equals("properties") && string5.equals(PROPERTIES_NAMESPACE)) {
                    Map<String, Object> map = PacketParserUtils.parseProperties(xmlPullParser);
                    for (String string7 : map.keySet()) {
                        presence.setProperty(string7, map.get(string7));
                    }
                    continue;
                }
                presence.addExtension(PacketParserUtils.parsePacketExtension(string4, string5, xmlPullParser));
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals("presence")) continue;
            bl = true;
        }
        return presence;
    }

    public static Map<String, Object> parseProperties(XmlPullParser xmlPullParser) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block2: while (true) {
            int n;
            if ((n = xmlPullParser.next()) == 2 && xmlPullParser.getName().equals("property")) {
                boolean bl = false;
                String string = null;
                String string2 = null;
                String string3 = null;
                Object object = null;
                while (true) {
                    Object object2;
                    if (bl) continue block2;
                    n = xmlPullParser.next();
                    if (n == 2) {
                        object2 = xmlPullParser.getName();
                        if (((String)object2).equals("name")) {
                            string = xmlPullParser.nextText();
                            continue;
                        }
                        if (!((String)object2).equals("value")) continue;
                        string2 = xmlPullParser.getAttributeValue("", "type");
                        string3 = xmlPullParser.nextText();
                        continue;
                    }
                    if (n != 3 || !xmlPullParser.getName().equals("property")) continue;
                    if ("integer".equals(string2)) {
                        object = Integer.valueOf(string3);
                    } else if ("long".equals(string2)) {
                        object = Long.valueOf(string3);
                    } else if ("float".equals(string2)) {
                        object = Float.valueOf(string3);
                    } else if ("double".equals(string2)) {
                        object = Double.valueOf(string3);
                    } else if ("boolean".equals(string2)) {
                        object = Boolean.valueOf(string3);
                    } else if ("string".equals(string2)) {
                        object = string3;
                    } else if ("java-object".equals(string2)) {
                        try {
                            object2 = StringUtils.decodeBase64(string3);
                            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object2));
                            object = objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (string != null && object != null) {
                        hashMap.put(string, object);
                    }
                    bl = true;
                }
            }
            if (n == 3 && xmlPullParser.getName().equals("properties")) break;
        }
        return hashMap;
    }

    public static XMPPError parseError(XmlPullParser xmlPullParser) throws Exception {
        int n;
        String string = "-1";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ArrayList<PacketExtension> arrayList = new ArrayList<PacketExtension>();
        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
            if (xmlPullParser.getAttributeName(n).equals("code")) {
                string = xmlPullParser.getAttributeValue("", "code");
            }
            if (!xmlPullParser.getAttributeName(n).equals("type")) continue;
            string2 = xmlPullParser.getAttributeValue("", "type");
        }
        n = 0;
        while (n == 0) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("text")) {
                    string3 = xmlPullParser.nextText();
                    continue;
                }
                String string5 = xmlPullParser.getName();
                String string6 = xmlPullParser.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(string6)) {
                    string4 = string5;
                    continue;
                }
                arrayList.add(PacketParserUtils.parsePacketExtension(string5, string6, xmlPullParser));
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("error")) continue;
            n = 1;
        }
        XMPPError.Type type = XMPPError.Type.CANCEL;
        try {
            if (string2 != null) {
                type = XMPPError.Type.valueOf(string2.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return new XMPPError(Integer.parseInt(string), type, string4, string3, arrayList);
    }

    public static PacketExtension parsePacketExtension(String string, String string2, XmlPullParser xmlPullParser) throws Exception {
        Object object = ProviderManager.getInstance().getExtensionProvider(string, string2);
        if (object != null) {
            if (object instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)object).parseExtension(xmlPullParser);
            }
            if (object instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(string, (Class)object, xmlPullParser);
            }
        }
        DefaultPacketExtension defaultPacketExtension = new DefaultPacketExtension(string, string2);
        boolean bl = false;
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string3 = xmlPullParser.getName();
                if (xmlPullParser.isEmptyElementTag()) {
                    defaultPacketExtension.setValue(string3, "");
                    continue;
                }
                n = xmlPullParser.next();
                if (n != 4) continue;
                String string4 = xmlPullParser.getText();
                defaultPacketExtension.setValue(string3, string4);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
        return defaultPacketExtension;
    }

    private static String getLanguageAttribute(XmlPullParser xmlPullParser) {
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            String string = xmlPullParser.getAttributeName(i);
            if (!"xml:lang".equals(string) && (!"lang".equals(string) || !"xml".equals(xmlPullParser.getAttributePrefix(i)))) continue;
            return xmlPullParser.getAttributeValue(i);
        }
        return null;
    }

    public static Object parseWithIntrospection(String string, Class clazz, XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        Object t = clazz.newInstance();
        while (!bl) {
            int n = xmlPullParser.next();
            if (n == 2) {
                String string2 = xmlPullParser.getName();
                String string3 = xmlPullParser.nextText();
                Class<?> clazz2 = t.getClass().getClass().getMethod("get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1), new Class[0]).getReturnType();
                Object object = PacketParserUtils.decode(clazz2, string3);
                t.getClass().getMethod("set" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1), clazz2).invoke(t, object);
                continue;
            }
            if (n != 3 || !xmlPullParser.getName().equals(string)) continue;
            bl = true;
        }
        return t;
    }

    private static Object decode(Class clazz, String string) throws Exception {
        if (clazz.getName().equals("java.lang.String")) {
            return string;
        }
        if (clazz.getName().equals("boolean")) {
            return Boolean.valueOf(string);
        }
        if (clazz.getName().equals("int")) {
            return Integer.valueOf(string);
        }
        if (clazz.getName().equals("long")) {
            return Long.valueOf(string);
        }
        if (clazz.getName().equals("float")) {
            return Float.valueOf(string);
        }
        if (clazz.getName().equals("double")) {
            return Double.valueOf(string);
        }
        if (clazz.getName().equals("java.lang.Class")) {
            return Class.forName(string);
        }
        return null;
    }
}

