/**
 * 
 */
package com.beem.project.beem.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPException;

import android.os.RemoteException;

import com.beem.project.beem.service.aidl.IRosterEntry;
import com.beem.project.beem.service.aidl.IRoster.Stub;

/**
 * @author darisk
 *
 */
public class RosterAdapter extends com.beem.project.beem.service.aidl.IRoster.Stub {

    private Roster adaptee;
    
    public RosterAdapter(Roster roster) {
	adaptee = roster;
    }
    
    @Override
    public IRosterEntry createEntry(String user, String name, String[] groups)
	    throws RemoteException {
	try {
	    adaptee.createEntry(user, name, groups);
	} catch (XMPPException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
	return null;
    }

    @Override
    public void createGroup(String groupname) throws RemoteException {
	// TODO Auto-generated method stub
	adaptee.createGroup(groupname);
    }

    @Override
    public List getEntries() throws RemoteException {
	// TODO Auto-generated method stub
	Collection<RosterEntry> col = adaptee.getEntries();
	ArrayList<IRosterEntry> result = new ArrayList<IRosterEntry>(col.size());
	for (RosterEntry rosterEntry : col ) {
	    result.add(new RosterEntryAdapter(rosterEntry));
	}
	return result;
    }
    

}
