/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jivesoftware.smack.util.collections.AbstractHashedMap;
import org.jivesoftware.smack.util.collections.DefaultMapEntry;
import org.jivesoftware.smack.util.collections.MapIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceMap<K, V>
extends AbstractHashedMap<K, V> {
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    protected int keyType;
    protected int valueType;
    protected boolean purgeValues;
    private transient ReferenceQueue queue;

    protected AbstractReferenceMap() {
    }

    protected AbstractReferenceMap(int n, int n2, int n3, float f, boolean bl) {
        super(n3, f);
        AbstractReferenceMap.verify("keyType", n);
        AbstractReferenceMap.verify("valueType", n2);
        this.keyType = n;
        this.valueType = n2;
        this.purgeValues = bl;
    }

    @Override
    protected void init() {
        this.queue = new ReferenceQueue();
    }

    private static void verify(String string, int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(string + " must be HARD, SOFT, WEAK.");
        }
    }

    @Override
    public int size() {
        this.purgeBeforeRead();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        this.purgeBeforeRead();
        return super.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry<K, V> hashEntry = this.getEntry(object);
        if (hashEntry == null) {
            return false;
        }
        return hashEntry.getValue() != null;
    }

    @Override
    public boolean containsValue(Object object) {
        this.purgeBeforeRead();
        if (object == null) {
            return false;
        }
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry<K, V> hashEntry = this.getEntry(object);
        if (hashEntry == null) {
            return null;
        }
        return hashEntry.getValue();
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (v == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purgeBeforeWrite();
        return super.put(k, v);
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        this.purgeBeforeWrite();
        return super.remove(object);
    }

    @Override
    public void clear() {
        super.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        return new ReferenceMapIterator(this);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ReferenceEntrySet(this);
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ReferenceKeySet(this);
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ReferenceValues(this);
        }
        return this.values;
    }

    protected void purgeBeforeRead() {
        this.purge();
    }

    protected void purgeBeforeWrite() {
        this.purge();
    }

    protected void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.purge(reference);
            reference = this.queue.poll();
        }
    }

    protected void purge(Reference reference) {
        int n = reference.hashCode();
        int n2 = this.hashIndex(n, this.data.length);
        AbstractHashedMap.HashEntry hashEntry = null;
        AbstractHashedMap.HashEntry hashEntry2 = this.data[n2];
        while (hashEntry2 != null) {
            if (((ReferenceEntry)hashEntry2).purge(reference)) {
                if (hashEntry == null) {
                    this.data[n2] = hashEntry2.next;
                } else {
                    hashEntry.next = hashEntry2.next;
                }
                --this.size;
                return;
            }
            hashEntry = hashEntry2;
            hashEntry2 = hashEntry2.next;
        }
    }

    @Override
    protected AbstractHashedMap.HashEntry<K, V> getEntry(Object object) {
        if (object == null) {
            return null;
        }
        return super.getEntry(object);
    }

    protected int hashEntry(Object object, Object object2) {
        return (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
    }

    @Override
    protected boolean isEqualKey(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    @Override
    public AbstractHashedMap.HashEntry<K, V> createEntry(AbstractHashedMap.HashEntry<K, V> hashEntry, int n, K k, V v) {
        return new ReferenceEntry<K, V>(this, (ReferenceEntry)hashEntry, n, k, v);
    }

    @Override
    protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
        return new ReferenceEntrySetIterator(this);
    }

    @Override
    protected Iterator<K> createKeySetIterator() {
        return new ReferenceKeySetIterator(this);
    }

    @Override
    protected Iterator<V> createValuesIterator() {
        return new ReferenceValuesIterator(this);
    }

    @Override
    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.keyType);
        objectOutputStream.writeInt(this.valueType);
        objectOutputStream.writeBoolean(this.purgeValues);
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.data.length);
        MapIterator<K, V> mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
        objectOutputStream.writeObject(null);
    }

    @Override
    protected void doReadObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.keyType = objectInputStream.readInt();
        this.valueType = objectInputStream.readInt();
        this.purgeValues = objectInputStream.readBoolean();
        this.loadFactor = objectInputStream.readFloat();
        int n = objectInputStream.readInt();
        this.init();
        this.data = new AbstractHashedMap.HashEntry[n];
        while ((object = objectInputStream.readObject()) != null) {
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
        this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeakRef<T>
    extends WeakReference<T> {
        private int hash;

        public WeakRef(int n, T t, ReferenceQueue referenceQueue) {
            super(t, referenceQueue);
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SoftRef<T>
    extends SoftReference<T> {
        private int hash;

        public SoftRef(int n, T t, ReferenceQueue referenceQueue) {
            super(t, referenceQueue);
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceMapIterator<K, V>
    extends ReferenceIteratorBase<K, V>
    implements MapIterator<K, V> {
        protected ReferenceMapIterator(AbstractReferenceMap<K, V> abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }

        @Override
        public K getKey() {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).getKey();
        }

        @Override
        public V getValue() {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).getValue();
        }

        @Override
        public V setValue(V v) {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).setValue(v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceValuesIterator<K, V>
    extends ReferenceIteratorBase<K, V>
    implements Iterator<V> {
        ReferenceValuesIterator(AbstractReferenceMap<K, V> abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceKeySetIterator<K, V>
    extends ReferenceIteratorBase<K, V>
    implements Iterator<K> {
        ReferenceKeySetIterator(AbstractReferenceMap<K, V> abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceEntrySetIterator<K, V>
    extends ReferenceIteratorBase<K, V>
    implements Iterator<Map.Entry<K, V>> {
        public ReferenceEntrySetIterator(AbstractReferenceMap<K, V> abstractReferenceMap) {
            super(abstractReferenceMap);
        }

        @Override
        public ReferenceEntry<K, V> next() {
            return this.superNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceIteratorBase<K, V> {
        final AbstractReferenceMap<K, V> parent;
        int index;
        ReferenceEntry<K, V> entry;
        ReferenceEntry<K, V> previous;
        K nextKey;
        V nextValue;
        K currentKey;
        V currentValue;
        int expectedModCount;

        public ReferenceIteratorBase(AbstractReferenceMap<K, V> abstractReferenceMap) {
            this.parent = abstractReferenceMap;
            this.index = abstractReferenceMap.size() != 0 ? abstractReferenceMap.data.length : 0;
            this.expectedModCount = abstractReferenceMap.modCount;
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                ReferenceEntry referenceEntry = this.entry;
                int n = this.index;
                while (referenceEntry == null && n > 0) {
                    referenceEntry = (ReferenceEntry)this.parent.data[--n];
                }
                this.entry = referenceEntry;
                this.index = n;
                if (referenceEntry == null) {
                    this.currentKey = null;
                    this.currentValue = null;
                    return false;
                }
                this.nextKey = referenceEntry.getKey();
                this.nextValue = referenceEntry.getValue();
                if (!this.nextNull()) continue;
                this.entry = this.entry.next();
            }
            return true;
        }

        private void checkMod() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean nextNull() {
            return this.nextKey == null || this.nextValue == null;
        }

        protected ReferenceEntry<K, V> nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next();
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.nextKey = null;
            this.nextValue = null;
            return this.previous;
        }

        protected ReferenceEntry<K, V> currentEntry() {
            this.checkMod();
            return this.previous;
        }

        public ReferenceEntry<K, V> superNext() {
            return this.nextEntry();
        }

        public void remove() {
            this.checkMod();
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.parent.remove(this.currentKey);
            this.previous = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedModCount = this.parent.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ReferenceEntry<K, V>
    extends AbstractHashedMap.HashEntry<K, V> {
        protected final AbstractReferenceMap<K, V> parent;
        protected Reference<K> refKey;
        protected Reference<V> refValue;

        public ReferenceEntry(AbstractReferenceMap<K, V> abstractReferenceMap, ReferenceEntry<K, V> referenceEntry, int n, K k, V v) {
            super(referenceEntry, n, null, null);
            this.parent = abstractReferenceMap;
            if (abstractReferenceMap.keyType != 0) {
                this.refKey = this.toReference(abstractReferenceMap.keyType, k, n);
            } else {
                this.setKey(k);
            }
            if (abstractReferenceMap.valueType != 0) {
                this.refValue = this.toReference(abstractReferenceMap.valueType, v, n);
            } else {
                this.setValue(v);
            }
        }

        @Override
        public K getKey() {
            return this.parent.keyType > 0 ? this.refKey.get() : super.getKey();
        }

        @Override
        public V getValue() {
            return this.parent.valueType > 0 ? this.refValue.get() : super.getValue();
        }

        @Override
        public V setValue(V v) {
            V v2 = this.getValue();
            if (this.parent.valueType > 0) {
                this.refValue.clear();
                this.refValue = this.toReference(this.parent.valueType, v, this.hashCode);
            } else {
                super.setValue(v);
            }
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null || v == null) {
                return false;
            }
            return this.parent.isEqualKey(k, this.getKey()) && this.parent.isEqualValue(v, this.getValue());
        }

        @Override
        public int hashCode() {
            return this.parent.hashEntry(this.getKey(), this.getValue());
        }

        protected <T> Reference<T> toReference(int n, T t, int n2) {
            switch (n) {
                case 1: {
                    return new SoftRef<T>(n2, t, ((AbstractReferenceMap)this.parent).queue);
                }
                case 2: {
                    return new WeakRef<T>(n2, t, ((AbstractReferenceMap)this.parent).queue);
                }
            }
            throw new Error("Attempt to create hard reference in ReferenceMap!");
        }

        boolean purge(Reference reference) {
            boolean bl = this.parent.keyType > 0 && this.refKey == reference;
            boolean bl2 = bl = bl || this.parent.valueType > 0 && this.refValue == reference;
            if (bl) {
                if (this.parent.keyType > 0) {
                    this.refKey.clear();
                }
                if (this.parent.valueType > 0) {
                    this.refValue.clear();
                } else if (this.parent.purgeValues) {
                    this.setValue(null);
                }
            }
            return bl;
        }

        protected ReferenceEntry<K, V> next() {
            return (ReferenceEntry)this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceValues<K, V>
    extends AbstractHashedMap.Values<K, V> {
        protected ReferenceValues(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList(this.parent.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceKeySet<K, V>
    extends AbstractHashedMap.KeySet<K, V> {
        protected ReferenceKeySet(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList(this.parent.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReferenceEntrySet<K, V>
    extends AbstractHashedMap.EntrySet<K, V> {
        protected ReferenceEntrySet(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : this) {
                arrayList.add(new DefaultMapEntry(entry.getKey(), entry.getValue()));
            }
            return arrayList.toArray(TArray);
        }
    }
}

