
/**
 * 
 */
package com.beem.project.beem;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.widget.Toast;

import com.beem.project.beem.service.XMPPConnectionAdapter;
import com.beem.project.beem.service.XMPPFacade;
import com.beem.project.beem.service.aidl.IRoster;
import com.beem.project.beem.service.aidl.IXMPPConnection;
import com.beem.project.beem.service.aidl.IXMPPFacade;
/**
 * This class is for the Beem service.
 * @author darisk
 *
 */
public class BeemService extends Service {

    private NotificationManager notificationManager;

    private IXMPPConnection connection;
    private SharedPreferences settings;
    private String mLogin;
    private String mPassword;
    private String mHost;

    private IXMPPFacade.Stub mBind;

    /*
     * (non-Javadoc)
     * 
     * @see android.app.Service#onBind(android.content.Intent)
     */
    @Override
    public IBinder onBind(Intent intent) {
	showBasicNotification(R.string.BeemServiceCreated);
	return mBind;
	// to forbid a client to bind
	// return null;
    }

    @Override
    public void onCreate() {
	super.onCreate();
	settings = getSharedPreferences(getString(R.string.PreferenceFileName),
		MODE_PRIVATE);
	mLogin = settings.getString(getString(R.string.PreferenceLoginKey), "");
	mPassword = settings.getString(
		getString(R.string.PreferencePasswordKey), "");
	mHost = settings.getString(getString(R.string.PreferenceHostKey), "");
	notificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
	connection = new XMPPConnectionAdapter("10.0.2.2", mLogin, mPassword); // address
	mBind = new XMPPFacade((XMPPConnectionAdapter) connection);
    }

    private void showBasicNotification(int stringResource) {
        String text = (String) getText(stringResource);
        Notification notif = new Notification(R.drawable.logo, text, System
                .currentTimeMillis());
        notif.defaults = Notification.DEFAULT_ALL;
        notif.setLatestEventInfo(this, text, text, PendingIntent.getActivity(
                this, 0, new Intent(), 0));
        notificationManager.notify(stringResource, notif);
        Toast toast = Toast.makeText(this, R.string.BeemServiceCreated,
                Toast.LENGTH_LONG);
        toast.show();
    }

    @Override
    public void onStart(Intent intent, int startId) {
	try {
	    connection.connectSync();
	} catch (RemoteException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
    }

    @Override
    public void onDestroy() {
	closeConnection();
	showBasicNotification(R.string.BeemServiceDestroyed);
    }

    private void closeConnection() {
	if (connection != null)
	    try {
		connection.disconnect();
	    } catch (RemoteException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	    }
    }

}
