/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemsExtension
extends NodeExtension
implements EmbeddedPacketExtension {
    protected ItemsElementType type;
    protected String attValue;
    protected List<? extends PacketExtension> items;

    public ItemsExtension(ItemsElementType itemsElementType, String string, List<? extends PacketExtension> list, String string2) {
        super(itemsElementType.getNodeElement(), string);
        this.type = itemsElementType;
        this.items = list;
        this.attValue = string2;
    }

    public ItemsExtension(String string, Integer n) {
        this(ItemsElementType.items, string, null, n == null ? null : n.toString());
    }

    public ItemsElementType getItemsElementType() {
        return this.type;
    }

    @Override
    public List<PacketExtension> getExtensions() {
        return this.getItems();
    }

    public List<? extends PacketExtension> getItems() {
        return this.items;
    }

    public String getAttributeValue() {
        return this.attValue;
    }

    @Override
    public String toXML() {
        if ((this.items == null || this.items.size() == 0) && this.attValue == null) {
            return super.toXML();
        }
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(" node='");
        stringBuilder.append(this.getNode());
        if (this.attValue != null) {
            stringBuilder.append("' ");
            stringBuilder.append(this.type.getElementAttribute());
            stringBuilder.append("='");
            stringBuilder.append(this.attValue);
            stringBuilder.append("'>");
        } else {
            stringBuilder.append("'>");
            for (PacketExtension packetExtension : this.items) {
                stringBuilder.append(packetExtension.toXML());
            }
        }
        stringBuilder.append("</");
        stringBuilder.append(this.getElementName());
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "Content [" + this.toXML() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ItemsElementType {
        items(PubSubElementType.ITEMS, "max_items"),
        retract(PubSubElementType.RETRACT, "notify");

        private PubSubElementType elem;
        private String att;

        private ItemsElementType(PubSubElementType pubSubElementType, String string2) {
            this.elem = pubSubElementType;
            this.att = string2;
        }

        public PubSubElementType getNodeElement() {
            return this.elem;
        }

        public String getElementAttribute() {
            return this.att;
        }
    }
}

